<?php
require_once('../lib/unicom.php');
ini_set('display_errors', DISP_ERR);

if (! $db = new PDO("sqlite:../data/unicale.db")) {
	die("DB Connection Failed.");
}
$db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

$unicom = new unicom();
$checkSubmit = new checkSubmit();
$confData = new confData();

$confData->getConfData($db);
$calname = $confData->conf["calname"];

$max_category = 30;

$error_f = 0;

?>
<html>
	<head>
		<link rel="stylesheet" type="text/css" href="../css/ucal_common.css"  media="all">
		<link rel="stylesheet" type="text/css" href="../css/ucalp.css" media="print">
		<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
		<link type="text/css" href="../js/jquery-ui-1.12.1.custom/jquery-ui.theme.min.css" rel="Stylesheet" />
		<script type="text/javascript" src="../js/jquery-3.2.1.min.js"></script>
		<script type="text/javascript" src="../js/jquery-ui-1.12.1.custom/jquery-ui.js"></script>
		<title><?php echo $calname; ?>カテゴリ管理</title>
	</head>
	<body>
	<div id="pageimage">
<?php
$category_colnames = array(
	'id',				 //0
	'表示順',			  //1
	'カテゴリ名',			//2
	'色',				//3
	'時間計算する',	   //4
	'表示する'	//5
);
$category_colnames_second = array(
	'',				 //0
	'',			  //1
	'',			//2
	'',			 //3
	'（未実装）',	//4
	''			//5
);
$category_colnames_required = array(
	0,  //0
	1,  //1
	1,  //2
	1,  //3
	0,  //4
	1   //5
);

if ($_SERVER["REQUEST_METHOD"] === "POST") {
	for($i=0; $i<$max_category; $i++){
		$update_id = 0;			 //0
		$update_dispid = "";		//1
		$update_categoryname = "";  //2
		$update_color = "";		 //3
		$update_f_calc = 0;		 //4
		$update_f_disp = 1;		 //5
		$error_f = 0;
		$error_msg = "";
		for($j=0; $j<=5; $j++){
			switch($j){
				case 0: //id
					$update_id = $i+1;
					break;
				case 1: //dispid
					$temp_arg = "uni/dispid_".($i+1);
					if(!empty($_POST[$temp_arg])){
						$update_dispid = (int) $_POST[$temp_arg];
					}
					break;
				case 2:
					$temp_arg = "uni/categoryname_".($i+1);
					if(!empty($_POST[$temp_arg])){
						$update_categoryname = $checkSubmit->sanitize($_POST[$temp_arg]);
					}
					break;
				case 3:
					$temp_arg = "uni/color_".($i+1);
					if(!empty($_POST[$temp_arg])){
						$update_color = (int) $_POST[$temp_arg];
					}
					break;
				case 4:
					$temp_arg = "uni/f_calc_".($i+1);
					if(!empty($_POST[$temp_arg])){
						$update_f_calc = (int) $_POST[$temp_arg];
					}
					break;
				case 5:
					$temp_arg = "uni/f_disp_".($i+1);
					if(!empty($_POST[$temp_arg])){
						$update_f_disp = (int) $_POST[$temp_arg];
					}else{
						$update_f_disp = 0;
					}
					break;
			}
		}

		//エラー条件の判定
		if( !empty($update_categoryname) ){
			if(($update_dispid == 0)||empty($update_dispid)){
				$update_dispid = 1;
			}
			
			if(empty($update_color) || ($update_color==0)){
				$error_f =1;
				$error_msg .= "色を選んでください。<br>";
			}
						
			if($update_f_disp == 1){
				
			}elseif($update_f_disp == 0){
				
			}else{
				$error_f =1;
				$error_msg .= "表示するかしないかを選んでください。<br>";
			}
		}

		$update_f = 0;
		if(($error_f ==0) &&( !empty($update_categoryname))){
			$update_f = 1;  //更新か挿入を実施する
		}
		if($update_f == 1){
			//カテゴリーデータの取得
			$sql  = "SELECT ";
			$sql .= "COUNT(id) AS hit ";
			$sql .= "FROM category ";
			$sql .= "WHERE id = ".$update_id ." ";
			
			$result = $db->query($sql);
			$category_exist = 0;
			while( $category_hit = $result->fetch()){
				$category_exist = $category_hit["hit"];
			}

			if($category_exist > 0){
				//UPDATE
				$sql  = "UPDATE category SET ";
				$sql .= "dispid = ".$update_dispid.",";
				$sql .= "categoryname = '".$update_categoryname."',";
				$sql .= "color = ".$update_color.",";
				$sql .= "f_calc = ".$update_f_calc.",";
				$sql .= "f_disp = ".$update_f_disp." ";
				$sql .= " WHERE ";
				$sql .= "id = ".$update_id;
								
				$db->exec('begin');
				try {
					$db->exec($sql);
					$db->exec('commit');

				} catch (Exception $e) {
					$db->exec("ROLLBACK;");
					echo $e->getTraceAsString();
					return;
				}
//			echo("更新しました。");

			}else{
				//INSERT
				$sql  = "INSERT INTO category (";
				$sql .= "id,";
				$sql .= "dispid,";
				$sql .= "categoryname,";
				$sql .= "color,";
				$sql .= "f_calc,";
				$sql .= "f_disp ";
				$sql .= ") VALUES ( ";
				$sql .= " ".$update_id.",";
				$sql .= " ".$update_dispid.",";
				$sql .= " '".$update_categoryname."',";
				$sql .= " ".$update_color.",";
				$sql .= " ".$update_f_calc.",";
				$sql .= " ".$update_f_disp." ";
				$sql .= ") ";

				$db->exec('begin');
				try {
					$db->exec($sql);
					$db->exec('commit');

				} catch (Exception $e) {
					$db->exec("ROLLBACK;");
					echo $e->getTraceAsString();
					return;
				}
//				echo("追加しました。");
			}
		}else{
//			echo("追加更新処理を行いません。");
		}
	}
}

echo("<h1 class='headerh1'><a href='../index.php'>".$calname."</a></h1>");
echo("<h2><span class='marker'>&#x2756;</span>&nbsp;カテゴリ管理</h2>");

if($error_f != 0){
	echo("<div class='error_msg'>".$error_msg."<div>");
}

?>

<form action="admin_category.php" method="post">
<?php

//カテゴリデータの取得
$sql  = "SELECT ";
$sql .= "id, ";
$sql .= "dispid,";
$sql .= "categoryname, ";
$sql .= "color, ";
$sql .= "f_calc, ";
$sql .= "f_disp ";
$sql .= "FROM category ";
$sql .= "ORDER BY id ";
	
$category_init = array();
$result = $db->query($sql);
while( $category_data = $result->fetch() )  {
	$category_init[$category_data["id"]]["dispid"] = $category_data["dispid"];
	$category_init[$category_data["id"]]["categoryname"] = $category_data["categoryname"];
	$category_init[$category_data["id"]]["color"] = $category_data["color"];
	$category_init[$category_data["id"]]["f_calc"] = $category_data["f_calc"];
	$category_init[$category_data["id"]]["f_disp"] = $category_data["f_disp"];
}

$category_color = $unicom->getcategoryColorList($db);
	
echo("<table class='admin1'>");
echo("<thead>");
echo("<tr>");
	for($i=0;$i<6;$i++){
		echo("<th>");
		echo($category_colnames[$i]);
		echo("<br>");
		echo("<span class='member_colnames_second'>");
		echo($category_colnames_second[$i]);
		echo("</span>");
		echo(disp_required($category_colnames_required,$i));
		echo("</th>");
	}
echo("</tr>");
echo("</thead>");
echo("<tbody>");
for($i=1;$i<=$max_category;$i++){
	echo("<tr>");
	for($j=0;$j<6;$j++){
		//初期値設定
		if(isset($category_init[$i])){
			$init_dispid = $category_init[$i]["dispid"];
			$init_categoryname  = $category_init[$i]["categoryname"];
			$init_color	 = $category_init[$i]["color"];
			$init_f_calc   = $category_init[$i]["f_calc"];
			$init_f_disp	= $category_init[$i]["f_disp"];
		}else{
			$init_dispid = 0;
			$init_categoryname  = "";
			$init_color	 = "";
			$init_f_calc   = "";
			$init_f_disp	= "";
		}

		echo("<td>");
		switch($j){
			case 0:
				echo($i);
				break;
			case 1:
//				echo("<select name='uni/dispid_".($i+1)."'>");
				echo("<select name='uni/dispid_".$i."'>");
				for($k=0; $k<$max_category; $k++){
					if($k == $init_dispid){
						$dispid_selected = " SELECTED";
					}else{
						$dispid_selected = "";
					}
					echo("<option value='".$k."' ".$dispid_selected.">".$k."</option>");
				}
				echo("</select>");
				break;
			case 2:
				echo("<input type='text' name='uni/categoryname_".$i."' value='".$init_categoryname."' size='16'>");
				break;
			case 3:
				$selected_color = "";
				echo("<select name='uni/color_".$i."' id='unicolor_".$i."' onChange='changeColor(this, ".$i.");'>");
				for($k=0; $k<$max_category; $k++){
					if($k == $init_color){
						$color_selected = " SELECTED";
						$selected_color = $category_color[$k];
					}else{
						$color_selected = "";
					}

					echo("<option value='".$k."' style='background-color:#".$category_color[$k].";' ".$color_selected.">".$category_color[$k]."</option>");
				}
				echo("</select>");
				
				echo("<span id='unicoloricon_".$i."' class='coloricon' style='background-color:#".$selected_color.";'>&nbsp;&nbsp;&nbsp;</span>");
				break;
			case 4:
				if($init_f_calc == 1){
					$checked_f_calc = " checked='CHECKED'";
				}else{
					$checked_f_calc = "";
				}
				echo("<input type='checkbox' name='uni/f_calc_".$i."' value='1' ".$checked_f_calc.">");
				break;
			case 5:
				if($init_f_disp == 1){
					$checked_f_disp = " checked='CHECKED'";
				}else{
					$checked_f_disp = "";
				}
				echo("<input type='checkbox' name='uni/f_disp_".$i."' value='1' ".$checked_f_disp.">");
				break;
		}
		echo("</td>");
	}
	echo("</tr>");
}
echo("</tbody>");
echo("</table>");
?>
<input type="submit" value="更新" class="ui-button ui-corner-all button">
<br>
<br>
<span class="normal">※カテゴリデータは削除できません。不必要なカテゴリは「表示する」のチェックを外して非表示にしてください。</span>
<br>
	

<script>
function changeColor(obj, selectid){
	var colorIconId = "unicoloricon_" + selectid;
	document.getElementById(colorIconId).style.backgroundColor = '#'+obj.options[obj.selectedIndex].text;
}
</script>

<?php
echo("</form>");
  
//$db->close();
$db = null;
echo("<a href='../index.php'>トップページへ戻る</a>");

$unicom->dispCopyright($confData);
$unicom->dispRss();

echo("</div>");
echo("</body>");
echo("</html>");

function disp_required($category_colnames_required,$checkcol){
	if($category_colnames_required[$checkcol] == 1){
		$outputString = "<span class='col_required'>必須</span>";
	}else{
		$outputString = "";
	}
	return $outputString;
}
?>
