<?php
class unicomdisp{
	function getCalendarDataDB($db, $dispWeekNum, $targetDate){
		$dayAdd = 0;
		$calendar_data = array();
		for($i=0;$i<$dispWeekNum;$i++){
			for($j=0;$j<7;$j++){
				$plus = "+".$dayAdd." day";
				$theDay = strtotime($plus,$targetDate);
				$theYYYY = date('Y', $theDay);
				$theMM = date('m', $theDay);
				$theDD = date('d', $theDay);
				$searchTargetDate = $theYYYY."-".$theMM."-".$theDD;

				$result = $this->getCalendarData($db,$searchTargetDate);
				$resultCounter = 0;
				while($data = $result->fetch()){
//					$calendar_data[$searchTargetDate][] = $data;
					$calendar_data[$searchTargetDate][$resultCounter] = $data;
					$resultCounter++;
				}
				$dayAdd++;
			}
		}
		return $calendar_data;
	}


	function getCalendarData($db, $searchTargetDate){
		$sql  = "SELECT ";
		$sql .= "calendar.id, ";
		$sql .= "datemode,";
		$sql .= "vaguedate_f, ";
		$sql .= "title, ";
		$sql .= "starttime, ";
		$sql .= "endtime, ";
		$sql .= "place, ";
		$sql .= "silent, ";
		$sql .= "starttime||timecvt.convert_time, ";
		$sql .= "category, ";
		$sql .= "detail, ";
		$sql .= "modified, ";
		$sql .= "f_insert, ";
		$sql .= "timecvt.timename_jp, ";
		$sql .= "category.color ";
		$sql .= "FROM ";
		$sql .= " (calendar ";
		$sql .= "LEFT OUTER JOIN timecvt ";
		$sql .= "ON calendar.starttime_zone = timecvt.id) ";
		$sql .= "LEFT OUTER JOIN category ";
		$sql .= "ON calendar.category = category.id ";
		$sql .= "WHERE startdate = :searchTargetDate ";
		$sql .= "ORDER BY starttime_real, modified DESC ";
		
		$result = $db->prepare($sql);
		$result->execute(array(':searchTargetDate' => $searchTargetDate));
		
		return $result;
	}

	//メンバーデータの取得
	function getMemberData($db, $calendar_id){
		$sql  = "SELECT ";
		$sql .= "memname1, ";
		$sql .= "memname2, ";
		$sql .= "memname3, ";
		$sql .= "member_color.color AS color ";
		$sql .= "FROM calendar_membername ";
		$sql .= "LEFT OUTER JOIN member_color ";
		$sql .= "ON calendar_membername.color = member_color.id ";
		$sql .= "WHERE calendar_membername.id = :calendar_id ";
		$sql .= "ORDER BY dispid ";

		$member_result = $db->prepare($sql);
		$member_result->execute(array(':calendar_id' => $calendar_id));
		return $member_result;
	}

	//表のヘッダー部分の曜日を表示
	function dispWeekHeader($monorsun, $weekStrArrayList, $weekNumArrayList, $weekCSSArrayList, $unicom){

		$outputString = "<div id='calendarArea'>\n";

		$outputString .= "	<table class='calendar1'>\n";
		$outputString .= "			<col class='colday'>\n";
		$outputString .= "		<colgroup class='colweek'>\n";
		$outputString .= "			<col class='colday'>\n";
		$outputString .= "			<col class='colday'>\n";
		$outputString .= "			<col class='colday'>\n";
		$outputString .= "			<col class='colday'>\n";
		$outputString .= "			<col class='colday'>\n";
		$outputString .= "			<col class='colday'>\n";
		$outputString .= "		</colgroup>\n";
		$outputString .= "		<tr>\n";

		for($i=0;$i<7;$i++){
			$weekStrArray[$i] = $weekStrArrayList[$i+$monorsun];
			$weekNumArray[$i] = $weekNumArrayList[$i+$monorsun];
			$weekCSSArray[$i] = "weektd_".$weekCSSArrayList[$i+$monorsun];
		}

		for($i=0;$i<7;$i++){
			$outputString .= "\t\t\t<td class='".$weekCSSArray[$i]."'><div class='week'>";
			$outputString .= $weekStrArray[$i];
			$outputString .= "</div></td>\n";
		}
		$outputString .= "				</tr>\n";
		
		$outputString = $unicom->insertIndent($outputString,2);
		return $outputString;
	}


	//時刻表示
	function dispTimeString($data){
		$tempstarttime = "";
		$calendar_output = "";
		if(!empty($data["timename_jp"])){
			if($data["timename_jp"] != "未定"){
				$calendar_output = $data["timename_jp"]."&nbsp";
				$calendar_output = "<span class='c1time'>".$calendar_output ."</span>";
				$calendar_output .= "<br>";
			}
		}elseif(!empty($data["starttime"]) && !empty($data["endtime"])){
			$tempstarttime = $this->insertHoursemicolon($data["starttime"]);
			$tempendtime = $this->insertHoursemicolon($data["endtime"]);
			$calendar_output = $tempstarttime."〜".$tempendtime;
			$calendar_output = "<span class='c1time'>".$calendar_output ."</span>";
			$calendar_output = $calendar_output."<br>";
		}elseif(!empty($data["starttime"])){
			$tempstarttime = $this->insertHoursemicolon($data["starttime"]);
			$calendar_output = "<span class='c1time'>".$tempstarttime ."</span>";
			$calendar_output = $calendar_output."<br>";
		}
		return $calendar_output;
	}

	//時刻表示をjson文字列にする
	function outputTimeStringJson($data){
		$tempstarttime = "";
		$jsonString = "";

		if(!empty($data["timename_jp"])){
		}elseif(!empty($data["starttime"]) && !empty($data["endtime"])){
			$tempstarttime = $this->insertHoursemicolon($data["starttime"]);
			$tempendtime = $this->insertHoursemicolon($data["endtime"]);
		}elseif(!empty($data["starttime"])){
			$tempstarttime = $this->insertHoursemicolon($data["starttime"]);
		}

		if($tempstarttime != ""){
			$jsonString .= '"starttime": '.json_encode($tempstarttime).',';
			$jsonString .= '"timename_jp": "",';
		}else{
			$jsonString .= '"starttime": "",';
			if($data["timename_jp"] != "未定"){
				$jsonString .= '"timename_jp": '.json_encode($data["timename_jp"]).',';
			}else{
				$jsonString .= '"timename_jp": "",';
			}
		}
		return $jsonString;
	}

	//各マスに「日」を表示
	function dispDayString($i, $j, $theWeekType, $theYYYYMMDD, $editable){
		$theYYYY = substr($theYYYYMMDD,0,4);
		$theMM   = substr($theYYYYMMDD,4,2);
		$theDD   = substr($theYYYYMMDD,6,2);
		$theMMDD = $theMM.$theDD;

		$outputString = "\t\t\t\t\t\t<div class='".$theWeekType."'>";

//		if($event_calendar_mode){
		if($editable){
			$link_head = "<a href='../calendar/edit.php?n=".$theYYYYMMDD."'>";
			$link_foot = "</a>";
		}else{
			$link_head = "";
			$link_foot = "";
		}

		if((($i==0)&&($j==0))||($theMMDD == "0101")){
			$outputString .= $link_head."<span class='monthsmall' style='float:left;'>".$theYYYY."/".$theMM."/&nbsp;</span><div style='text-align:left; margin: 0 0 0 0; padding: 0 0 0 0;'>".$theDD."</div>".$link_foot;
		
		}elseif($theDD == 1){
			$outputString .= $link_head."<span class='monthsmall' style='float:left;'>".$theYYYY."/".$theMM."/&nbsp;</span><div style='text-align:left; margin: 0 0 0 0; padding: 0 0 0 0;'>".$theDD."</div>".$link_foot;
//		}elseif($j == 0) {
//			$outputString .= $link_head."<span class='monthsmall' style='float:left;'>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;".$theMM."/&nbsp;</span><div style='text-align:left; margin: 0 0 0 0; padding: 0 0 0 0;'>".$theDD."</div>".$link_foot;
		}else{
			$outputString .= $link_head.$theDD.$link_foot;
		}
		$outputString .= "</div>\n";
		return $outputString;
	}

	//曜日ごとのstyle名を取得
	function getWeekStyle($theW, $holiday_f){
		switch($theW){
			case 0:
				$theWeekType = "datesun";
				break;
			case 6:
				if($holiday_f == 1){
					$theWeekType = "datesun";
				}else{
					$theWeekType = "datesat";
				}
				break;
			default:
				if($holiday_f == 1){
					$theWeekType = "datesun";
				}else{
					$theWeekType = "datenormal";
				}
		}
		return $theWeekType;
	}

	//表示用「場所」文字列生成
	function dispPlace($data){
		$place_str="";
		if(!empty($data["place"])){
			$place_str="(".$data["place"].")";
		}
		return $place_str;
	}

	//祝日の判定
	function getHolidaysName($holiday_static, $holiday){
		$holiday_f = 0;
		$holiday_title = array();

		if(!empty($holiday_static)){
			$holiday_title[] = $holiday_static;
			$holiday_f = 1;
		}
		if(!empty($holiday)){
			$holiday_title[] = $holiday;
			$holiday_f = 1;
		}
		$holidayTitles[] = $holiday_title;
		
		$holidayInfo['holiday_f'] = $holiday_f;
		$holidayInfo['holidayTitles'] = $holidayTitles;
		return $holidayInfo;
	}



	function get_holiday_static($db){
	
		$holiday_static = array();
		$sql  = "SELECT ";
		$sql .= "holidaydate,"; //MMDD
		$sql .= "holidayname ";
		$sql .= "FROM holiday_static ";
		try {
			$result = $db->query($sql);
		} catch (Exception $e) {
			$db->exec("ROLLBACK;");
			echo $e->getTraceAsString();
			return;
		}
		
		while( $data = $result->fetch() )  {
			$holiday_static[$data["holidaydate"]] = $data["holidayname"];
		}
		return $holiday_static;
	}

	function get_holiday($db){
	
		$holiday = array();
		$sql  = "SELECT ";
		$sql .= "holidaydate,"; //YYYYMMDD
		$sql .= "holidayname ";
		$sql .= "FROM holiday ";
		try {
			$result = $db->query($sql);
		} catch (Exception $e) {
			$db->exec("ROLLBACK;");
			echo $e->getTraceAsString();
			return;
		}
		
		while($data = $result->fetch() )  {
			$holiday[$data["holidaydate"]] = $data["holidayname"];
		}
		return $holiday;
	}
	
	function get_event_static($db){	//get_holiday_staticとは返り値の形式が異なるので注意
	
		$event_static = array();
		$sql  = "SELECT ";
		$sql .= "eventdate,"; //MMDD
		$sql .= "eventname, ";
		$sql .= "url ";
		$sql .= "FROM event_static ";
		try {
			$result = $db->query($sql);
		} catch (Exception $e) {
			$db->exec("ROLLBACK;");
			echo $e->getTraceAsString();
			return;
		}
		$i=0;
		while( $data = $result->fetch() )  {
			$event_static[$i]['eventdate'] = $data["eventdate"];
			$event_static[$i]['eventname'] = $data["eventname"];
			$event_static[$i]['url'] = $data["url"];
			$i++;
		}
		return $event_static;
	}

	function insertHoursemicolon($hourstring){
		$HH = (int) substr($hourstring,0,2);
		$MM = (int) substr($hourstring,2,2);
		$MMstr = sprintf("%02d",$MM);
		return $HH.":".$MMstr;
	}

	function dispKeiji($basedir, $mode, $writedata = "", $calname='', $unicom='', $confData=''){ //mode "keijiwrt": 書き込み処理, "keiji": 掲示板表示	
		$getMode = $mode;
		$getKeiji = $writedata;
		$keijifilename = "/keiji.txt";
		$output_target = "";
		
		if($getMode =="keijiwrt"){
			$keijiFile = $basedir.$keijifilename;
			if(file_exists($keijiFile)){
	//			if(FILE_LOCK)lock($keijiFile);
				$handle = fopen($keijiFile, 'w');
				if($handle){
					fwrite($handle, $getKeiji);
	//				$unicom->echsw($output_target, $getKeiji);
					fclose($handle);
				}
	//			if(FILE_LOCK)unlock($keijiFile);
	//			if(PERM_CHG){
	//				set_error_handler("permChangeError");
	//				chmod($keijiFile, 0666);
	//				set_error_handler("");
	//			}
				$Message = "掲示板に書き込みました。";
			}
		}
	
		if($getMode =="keiji"){
			$basedirPerm = fileperms($basedir.$keijifilename);
			if(($basedirPerm & 0x0002)!=true){;
				$unicom->echsw($output_target, "data/".$keijifilename."ファイルに書き込み権限がありません。<br>");
				$unicom->echsw($output_target, "コマンドラインなどから下記コマンドを入力し，dataディレクトリに書き込み権限を与えてください。<br>");
				$unicom->echsw($output_target, "chmod 666 -R ".$basedir.$keijifilename."<br>");
				exit;
			}
			$keijiFile = $basedir.$keijifilename;
			if(file_exists($keijiFile)){
				$readKeijiFile = "";
	//			if(FILE_LOCK)lock($keijiFile);
				$handle = fopen($keijiFile, "r");
				if($handle){
					$readKeijiFile = file_get_contents($keijiFile);
					if($readKeijiFile != ""){
						$readKeijiFile = str_replace("<br>","\n",$readKeijiFile);
					}
					fclose($handle);
				}
	//			if(FILE_LOCK)unlock($keijiFile);
				$unicom->echsw($output_target, "<html>\n");
				$unicom->echsw($output_target, "<head>\n");
				$unicom->echsw($output_target, "<title> ".$calname."ほぼ１行掲示板</title>\n");
				$unicom->echsw($output_target, "<link rel=\"stylesheet\" type=\"text/css\" href=\"../css/ucal_common.css\"  media=\"all\">\n");
				$unicom->echsw($output_target, "<link rel=\"stylesheet\" type=\"text/css\" href=\"../css/ucal.css\"  media=\"all\">\n");
				$unicom->echsw($output_target, "<meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\">\n");
				$unicom->echsw($output_target, "</head>\n");
				$unicom->echsw($output_target, "<body>\n");
				$unicom->echsw($output_target, "<div id=\"pageimage\">\n");
				$unicom->echsw($output_target, "<a href=\"../\" class=\"headerh1\">\n");
				$unicom->echsw($output_target, "<h1>".$calname."</h1>\n");
				$unicom->echsw($output_target, "</a>\n");
				$unicom->echsw($output_target, "<h2>ほぼ１行掲示板</h2>\n");
				$unicom->echsw($output_target, "<form action=\"../index.php\" method=\"get\">\n");
				$unicom->echsw($output_target, "<textarea cols=\"50\" rows=\"4\" name=\"keiji\">\n");
				$unicom->echsw($output_target, stripslashes($readKeijiFile));
				$unicom->echsw($output_target, "</textarea>\n");
				$unicom->echsw($output_target, "<br>\n");
				$unicom->echsw($output_target, "<input type=\"submit\" name=\"sbmt\" value=\"更新\">\n");
				$unicom->echsw($output_target, "<input type=\"hidden\" name=\"mode\" value=\"keijiwrt\">\n");
				$unicom->echsw($output_target, "</form>\n");
				$unicom->dispCopyright($confData);
				$unicom->dispRss();
				$unicom->echsw($output_target, "</div>\n");
				$unicom->echsw($output_target, "</body>\n");
				$unicom->echsw($output_target, "</html>\n");
				exit;
			}
		}
		return($Message);
	}
	
	function getreadKeijiFile($basedir){
		$keijifilename = "/keiji.txt";
		$keijiFile = $basedir.$keijifilename;
		$readKeijiFile = "";
	
		$keijiFile = $basedir.$keijifilename;
		if(file_exists($keijiFile)){
	//		if(FILE_LOCK)lock($keijiFile);
			$handle = fopen($keijiFile, "r");
			if($handle){
				$readKeijiFile = file_get_contents($keijiFile);
				if($readKeijiFile != ""){
					$readKeijiFile = stripslashes($readKeijiFile);
					$readKeijiFile = str_replace("\n","<br>",$readKeijiFile);
					$readKeijiFile = "<a href=\"../index.php?mode=keiji\">".$readKeijiFile."</a>";
				}else{
					$readKeijiFile = "<a href=\"../index.php?mode=keiji\">ほぼ1行掲示板...</a>";
				}
				fclose($handle);
			}
	//		if(FILE_LOCK)unlock($keijiFile);
		}else{
			$readKeijiFile = "<a href=\"../index.php?mode=keiji\">ほぼ1行掲示板...</a>";
			//		touch($keijiFile);
	//		if(PERM_CHG){
	//			set_error_handler("permChangeError");
	//			chmod($keijiFile,0666);
	//			set_error_handler("");
	//		}
		}
		return $readKeijiFile;
	}
	
	function readPickup($db,$unicom,$editable){
		$last_pickup = "";
		$sql  = "SELECT ";
		$sql .= "calendar.id, ";
		$sql .= "startdate, ";
		$sql .= "title, ";
		$sql .= "starttime, ";
		$sql .= "endtime, ";
		$sql .= "place, ";
		$sql .= "silent, ";
		$sql .= "category, ";
		$sql .= "detail, ";
		$sql .= "modified, ";
		$sql .= "f_insert, ";
		$sql .= "pickup, ";
		$sql .= "category.categoryname, ";
		$sql .= "category_color.color AS categorycolor, ";
		$sql .= "timecvt.timename_jp AS timename ";
		$sql .= "FROM (((calendar ";
		$sql .= "LEFT OUTER JOIN timecvt ";
		$sql .= "ON calendar.starttime_zone = timecvt.id) ";
		
		$sql .= "LEFT OUTER JOIN category ";
		$sql .= "ON calendar.category = category.id) ";
		
		$sql .= "LEFT OUTER JOIN category_color ";
		$sql .= "ON category.color = category_color.id) ";
	
		$sql .= "WHERE ";
		$sql .= "pickup > 0 ";
		$sql .= "ORDER BY pickup, modified DESC, startdate, starttime ";
	
		$new_counter = 0;
		$counter = 0;
		$result = $db->query($sql);
		$i = 0;
		$pickup_data = "<table class='pickup'>\n";
		while($data = $result->fetch()){
			$dayBetween = 3;	//day   pickupに表示する日数
			$day1 = time();
			$day2 = strtotime($data["modified"]);
			$sa = $day1 - $day2;
			switch($data["pickup"]){
				case 0:					//表示しない
					$f_disp_line = 0;
					break;
				case 1:					//常に表示
					$f_disp_line = 1;
					break;
				case 2:					//3日間のみ表示
					$new_counter++;
					if($sa < ($dayBetween * 24 * 60 * 60)){ //3日以内ならば
						$f_disp_line = 1;
					}else{
						$f_disp_line = 0;
					}
					break;
			}
	   
			if(($f_disp_line == 1) && ($new_counter <= 10)){
				$trstyle = "";
				if($last_pickup != $data["pickup"]){
					if($counter != 0){
						$trstyle = " style='border-top: 2px solid #e2e2e2;'";
					}
				}
				$pickup_data .= "\t<tr".$trstyle.">\n";
				
				$theDate = str_replace("-","",$data["startdate"]);
				
					
				$pickup_data .= "\t\t<td style='width: 8em;'>";
				if($data["pickup"]==1){
					$pickup_data .= "<span style='color:#ff8787;'>&#10000;</span>";
				}else{
					$pickup_data .= "<span style='color:#b7b7b7;'>・</span>";
				}
				$pickup_data .= "<a href='../index.php?d=".$theDate."&focus=".$theDate."#focus'>".str_replace("-","/",$data["startdate"])."</a></td>\n";
	
				$pickup_data .= "\t\t<td style='width: 8em;'>";
				if(!empty($data["timename"])){
					if($data["timename"] != "未定"){
						$pickup_data .= $data["timename"];
					}else{
						$pickup_data .= "&nbsp;";
					}
	
				}else{
					$pickup_data .= substr_replace($data["starttime"],":",2,0);
					if(!empty($data["endtime"])){
						$pickup_data .= "〜".substr_replace($data["endtime"],":",2,0);
					}
				}
				$pickup_data .= "</td>\n";


				if($editable){
					$link_head = "<a href='../calendar/edit.php?id=".$data["id"]."'>";
					$link_foot = "</a>";
				}else{
					$link_head = "";
					$link_foot = "";
				}		
				
				$pickup_data .= "\t\t<td>".$link_head."<span style='imgicon'>".$unicom->getNewIcon($data["modified"],$data["f_insert"])."</span>&nbsp;".$data["title"];

				if(!empty($data["place"])){
					$pickup_data .= "(".$data["place"].")";
				}
				$pickup_data .= $link_foot;
				$pickup_data .= "</td>\n";
		//		$pickup_data .= "<td>".$data["category"]."</td>";
	
				$pickup_data .= "\t\t<td><span style='font-size: 80%; background-color:#".$data["categorycolor"].";border-radius:2px;	margin: 2px 2px 0.4em 2px; padding: 2px;'>".mb_substr($data["categoryname"],0, 10,"utf-8")."</span>";
				$pickup_data .= $link_head.mb_substr($data["detail"], 0, 20,"utf-8").$link_foot."</td>\n";
				$pickup_data .= "\t</tr>";
				$pickup_data .= "\n";
			}
			$last_pickup = $data["pickup"];
			$counter++;
		}
		$pickup_data .= "</table>\n";
		return $pickup_data;
	}
}


?>