<?php
define("UVERSION","3.60");
define("F_FOOTERDISP","1");
define("DISP_ERR",0);		//PHPエラー表示 0:しない，1:する
define("ESC_IFNOTERR",0);	//通常は0。IF NOT EXISTでエラーが発生する場合に1にする。
define("TIMESPAN",0);	//リストボックスの分単位 0:30分単位（デフォルト），1:15分単位 ，2: 10分単位 
define("ANNONYMOUS_MODE",0);	//UNICALEの名称を変更

date_default_timezone_set('Asia/Tokyo');

class unicom{
	public $outputJsonString = "";

	function echsw($target = 0, $str){
		switch ($target){
			case 1:		//jsonp
			case 2:		//json
				//NOP
				break;
			default:	//0:HTML
				echo($str);
		}
	}

	function bufsw($target = 0, $str){
		switch ($target){
			case 1:		//jsonp
			case 2:		//json
				//NOP
				break;
			default:	//0:HTML
				return($str);
		}
	}


	function storeJson($target = 0, $jsonOneLine){
		switch ($target){
			case 1:		//jsonp
			case 2:		//json
				$this->outputJsonString .= $jsonOneLine."\n";
				break;
			default:	//0:HTML
				// NOP
		}

	}

	function dispHeader($output_target, $readKeijiFile, $db, $startyear, $endyear, $currentYear, $currentMonth, $currentDay){
		$outputStr = "\n";
		$outputStr .= "		<div class='keiji'>\n";
		$outputStr .= "			".$readKeijiFile."\n";
		$outputStr .= "		</div>\n";
		$outputStr .= "		<div id='header1'>\n";
		$outputStr .= "			<form action='../calendar/edit.php' method='post' name='form1'>\n";
		$outputStr .= "				<div id='header2'>\n";
		$outputStr .= "					<div class='text ui-widget-content ui-corner-all' style='padding: 10px;'>\n";
		$outputStr .= "						<div class='inputbar1 ui-corner-all'>\n";
		$outputStr .= $this->insertIndent($this->makeYearListbox(0,$startyear,$endyear), 7);
		$outputStr .= "							年\n";
		$outputStr .= $this->insertIndent($this->makeMonthListbox(),7);
		$outputStr .= "							月\n";
		$outputStr .= $this->insertIndent($this->makeDayListbox(),7);
		$outputStr .= "							日&nbsp;&nbsp; 用事\n";
		$outputStr .= "							<input type='text' name='uni/title' size='30' value=''>&nbsp;&nbsp; 場所\n";
		$outputStr .= "							<input type='text' name='uni/place' size='24' value='' style='width:100px;'>&nbsp;&nbsp;\n";
		$outputStr .= "							<input type='submit' value='追加' class='button'>\n";
		$outputStr .= "						</div>\n";
		$outputStr .= "						<div class='inputbar2 ui-corner-all'>\n";
		$outputStr .= "							時刻\n";
		$outputStr .= $this->insertIndent($this->makeStartTimeListbox('',TIMESPAN), 7);
		$outputStr .= "							～\n";
		$outputStr .= $this->insertIndent($this->makeEndTimeListbox('',TIMESPAN), 7);
		$outputStr .= "							&nbsp;&nbsp; カテゴリ\n";
		$outputStr .= $this->insertIndent($this->makeCategoryListbox($db), 7);
		$outputStr .= "							&nbsp;&nbsp; ピックアップ表示\n";
		$outputStr .= $this->insertIndent($this->makePickupListbox(2), 7);
		$outputStr .= "							\n";
		$outputStr .= "							<div class='hanrei'>\n";
		$outputStr .= $this->insertIndent($this->makeMemberCheckboxes2($db), 7);
		$outputStr .= "								\n";
		$outputStr .= "							</div>\n";
		$outputStr .= "						</div>\n";
		$outputStr .= "					</div>\n";
		$outputStr .= "				</div>\n";
		$outputStr .= "				<input type='hidden' name='currentdate' value='".$currentYear.$currentMonth.$currentDay."'>\n";
		$outputStr .= "			</form>\n";
		$outputStr .= "		</div>\n";
		
		return $outputStr;
	}

	function dispNavi($makeNavi, $currentYear, $currentMonth, $currentDay, $monthnavistartmonth){
		$outputStr = "";
		$outputStr .= "<div class='navi'>\n";
		$outputStr .= "	<div class='size1'>\n";
		$outputStr .= "		<a href='../index.php' class='navibutton ui-button ui-state-default ui-corner-all ui-button-text-only' id='thisweek' title='Ctrl+0'>今週</a>&nbsp;&nbsp;\n";
		$outputStr .= "		<a href='../index.php?d=".$makeNavi->prevMonth($currentYear,$currentMonth,$currentDay)."' class='navibutton ui-button ui-state-default ui-corner-all ui-button-text-only' id='prevmonth' title='Ctrl+↑'>&lt;&lt;&nbsp;前月</a>&nbsp;\n";
		$outputStr .= "		<a href='../index.php?d=".$makeNavi->prevWeek($currentYear,$currentMonth,$currentDay)."' class='navibutton ui-button ui-state-default ui-corner-all ui-button-text-only' id='prevweek' title = 'Ctrl+←'>&lt;&nbsp;前の週</a>&nbsp;\n";
		$outputStr .= "		<a href='../index.php?d=".$makeNavi->nextWeek($currentYear,$currentMonth,$currentDay)."' class='navibutton ui-button ui-state-default ui-corner-all ui-button-text-only' id='nextweek' title= 'Ctrl+→'>次の週&nbsp;&gt;</a>&nbsp;\n";
		$outputStr .= "		<a href='../index.php?d=".$makeNavi->nextMonth($currentYear,$currentMonth,$currentDay)."' class='navibutton ui-button ui-state-default ui-corner-all ui-button-text-only' id='nextmonth' title='Ctrl+↓'>次月&nbsp;&gt;&gt;</a>&nbsp;\n";
		$outputStr .= "	</div>\n";
		$outputStr .= "</div>\n";
		$outputStr .= "<span class='monthNavi'>\n";

		//MonthNavi
		$monthNavi = $this->getMonthNavi($monthnavistartmonth);
		$lastYear = 0;
		for($i=0;$i<12;$i++){
			if($lastYear != substr($monthNavi[$i],0,4)){
				$outputStr .= "<span class='silent'>".substr($monthNavi[$i],0,4)."</span>&nbsp;&nbsp;";
			}
			$outputStr .= "<a href='../index.php?d=".$monthNavi[$i]."'>".substr($monthNavi[$i],4,2)."</a>&nbsp;&nbsp;\n";
			$lastYear = substr($monthNavi[$i],0,4);
		}
		$outputStr .= "</span>\n";


		$outputStr = $this->insertIndent($outputStr,4);
		return $outputStr;
	}

	function getMonthNavi($monthnavistartmonth){
		$monthNaviCalc = Array( 1, 2, 3, 4, 5, 6, 7, 8, 9,10,11,12, 1, 2, 3, 4, 5, 6, 7, 8, 9,10,11);
		$yearNaviCalc = Array(  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1);
	
		$monthNavi = array();
		$nowYYYY = date('Y',time());
		$nowMM = date('m',time());
		if($monthnavistartmonth>$nowMM){
			$nowYYYY--;
		}
		for($i=$monthnavistartmonth; $i<($monthnavistartmonth+12); $i++){
			$monthNavi[] = ($nowYYYY+$yearNaviCalc[$i-1]).sprintf("%02d",$monthNaviCalc[$i-1])."01";
		}
		return $monthNavi;
	}

	function makeStartTimeListbox($selected = 'ALL1', $timespan = 0){
		$ALL1 = "(未定)";
		$ALL2 = "終日";
		$AM   = "午前";
		$PM   = "午後";

		$listbox = array();
		$listbox = $this->timeArray($timespan); //$timespan 0:30min 1:15min
		array_unshift($listbox, Array("ALL1",$ALL1),
								Array("ALL2",$ALL2),
								Array("AM",$AM),
								Array("PM",$PM)
		);
		$listBoxStr = "<select name='uni/starttime'>\n";
		
		foreach($listbox as $s){
			$listBoxStr .= "\t<option value='".$s[0]."'";
			if($selected == $s[0]){
				$listBoxStr.=" selected";
			}
			$listBoxStr.= ">".$s[1]."</option>\n";
		}
		$listBoxStr .="</select>\n";
		return $listBoxStr;
	}

	function makeEndTimeListbox($selected = '', $timespan = 0){
		$listbox = array();
		$listbox = $this->timeArray($timespan); //$timespan 0:30min 1:15min
		array_unshift($listbox, Array("","---"));
		$listBoxStr = "<select name='uni/endtime'>\n";
		
		foreach($listbox as $s){
			$listBoxStr .= "\t<option value='".$s[0]."'";
			if($selected == $s[0]){
				$listBoxStr.=" selected";
			}
			$listBoxStr.= ">".$s[1]."</option>\n";
		}
		$listBoxStr .="</select>\n";
		return $listBoxStr;
	}


	function timeArray($timespan = 0){
		$timeArray = array();
		$startHour = 5; //(0-23)
		$endHour   = 24;//(1-24)
		
		for($i=$startHour;$i<=$endHour;$i++){
			switch ($timespan){
				case 0:
					$timeArray[]  = Array( sprintf("%02d",$i)."00", sprintf("%02d",$i).":00");
					$timeArray[]  = Array( sprintf("%02d",$i)."30", sprintf("%02d",$i).":30");	
					break;
				case 1:
					$timeArray[]  = Array( sprintf("%02d",$i)."00", sprintf("%02d",$i).":00");
					$timeArray[]  = Array( sprintf("%02d",$i)."15", sprintf("%02d",$i).":15");
					$timeArray[]  = Array( sprintf("%02d",$i)."30", sprintf("%02d",$i).":30");
					$timeArray[]  = Array( sprintf("%02d",$i)."45", sprintf("%02d",$i).":45");
					break;
				case 2:	
					$timeArray[]  = Array( sprintf("%02d",$i)."00", sprintf("%02d",$i).":00");
					$timeArray[]  = Array( sprintf("%02d",$i)."10", sprintf("%02d",$i).":10");
					$timeArray[]  = Array( sprintf("%02d",$i)."20", sprintf("%02d",$i).":20");
					$timeArray[]  = Array( sprintf("%02d",$i)."30", sprintf("%02d",$i).":30");
					$timeArray[]  = Array( sprintf("%02d",$i)."40", sprintf("%02d",$i).":40");
					$timeArray[]  = Array( sprintf("%02d",$i)."50", sprintf("%02d",$i).":50");
					break;
				default:
					$timeArray[]  = Array( sprintf("%02d",$i)."00", sprintf("%02d",$i).":00");
					$timeArray[]  = Array( sprintf("%02d",$i)."30", sprintf("%02d",$i).":30");
			}
		}
		return $timeArray;
	}

	function makeMonthListbox($selected=0){
		if($selected == 0){ $selected = date("m");}
			
		$listBoxStr = "<select name='uni/month'>\n";
		for($i=1;$i<=12;$i++){
			$listBoxStr .= "\t<option value='".sprintf("%02d",$i)."'";
			if($selected == $i){
				$listBoxStr.=" selected";
			}
			$listBoxStr.= ">".$i."</option>\n";
		}
		$listBoxStr .="</select>\n";
		return $listBoxStr;
	}

	function makeDayListbox($selected=0, $targetdate = ""){
		if($selected == 0){ $selected = date("d");}
		if($targetdate == ""){
			$targetdate = time();
		}
//		$endDay = date('t', $targetdate);
		$endDay = 31;

		$listBoxStr = "<select name='uni/day'>\n";
		for($i=1;$i<=$endDay;$i++){
			$listBoxStr .= "\t<option value='".sprintf("%02d",$i)."'";
			if($selected == $i){
				$listBoxStr.=" selected";
			}
			$listBoxStr.= ">".$i."</option>\n";
		}
		$listBoxStr .="</select>\n";
		return $listBoxStr;
	}

	function makeYearListbox($selected=0, $startYear=0, $endYear=0){
		if($selected == 0){ $selected = date("Y");}
		if($startYear == 0){$startYear = date("Y")-2;}
		if($endYear == 0){$endYear = date("Y")+2;}
			
		$listBoxStr = "<select name='uni/year'>\n";
		for($i=$startYear;$i<=$endYear;$i++){
			$listBoxStr .= "\t<option value='".$i."'";
			if($selected == $i){
				$listBoxStr.=" selected";
			}
			$listBoxStr.= ">".$i."</option>\n";
		}
		$listBoxStr .="</select>\n";
		return $listBoxStr;
	}

	function makePickupListbox($selected = 2){
		$listBoxStr = "<select name='uni/pickup'>\n";

		for($i=0;$i<=2;$i++){
			$listBoxStr .= "\t<option value='".$i."'";
			if($selected == $i){
				$listBoxStr.=" selected";
			}
			switch($i){
				case 0:
					$listBoxStr.= ">表示しない</option>\n";
					break;
				case 1:
					$listBoxStr.= ">常に表示</option>\n";
					break;
				case 2:
					$listBoxStr.= ">3日間だけ表示</option>\n";
					break;
			}
		}
		$listBoxStr .="</select>\n";
		return $listBoxStr;
	}

	function makeMemberCheckBoxes2($db, $calendar_id=0, $type=1){ 
		//$memberList, $memberListKey, $checkd: Array, $type: 1:NormalCheckboxes 2:textList 3:SimpleTextList
		$checkboxStr="";
		$textListStr="";
		$textListStr2="";
				
		//メンバーデータの取得
		$sql  = "SELECT ";
		$sql .= "member.id AS id, ";
		$sql .= "memname1, ";
		$sql .= "memname2, ";
		$sql .= "memname3, ";
		$sql .= "f_small, ";
		$sql .= "space, ";
		$sql .= "member_color.color AS color ";
		$sql .= "FROM member ";
		$sql .= "LEFT OUTER JOIN member_color ";
		$sql .= "ON member.color = member_color.id ";
		$sql .= "WHERE f_disp = 1 ";
		$sql .= "ORDER BY member.dispid ";
		$member_result = $db->query($sql);

		$member_output = "";
		$checkboxStr = "";
		$textListStr = "";
		$textListStr2 = "";
		$space = 0;
		
		while( $member_data = $member_result->fetch()){
			if(isset($calendar_id)){
				$sql  = "SELECT ";
				$sql .= "COUNT(calendar_id) AS cnt ";
				$sql .= "FROM calendar_member ";
				$sql .= "WHERE ";
				$sql .= "calendar_id = :calendar_id ";
				$sql .= "AND ";
				$sql .= "member_id = :member_data ";

				$checked_result = $db->prepare($sql);
				$checked_result->execute(array(':calendar_id' => $calendar_id, ':member_data' => $member_data['id']));

				while( $checked_data = $checked_result->fetch()){
					if($checked_data['cnt'] > 0){
						$checkedStr = " CHECKED";
					}else{
						$checkedStr = "";
					}
				}
			}else{
				$checkedStr = "";
			}

			$space = (int) $member_data['space'];
			
			$checkboxStr .= '<span style="height: 1.2em; width: 1em; vertical-align: middle; padding: 0 0 0 0; background-color:#'. $member_data['color'].'; margin: 4px;">';
			$checkboxStr .= '<input type="checkbox" name="uni/member[]" style="color: #'. $member_data['color'].'; outline: 4px solid #'. $member_data['color'].'; padding: 0; background-color:#'. $member_data['color'].'; text-align: center; vertical-align: middle; height: auto; width: auto;" value="'.$member_data['id'].'"'.$checkedStr.'>';
			$checkboxStr .= '</span>';

			if($member_data['f_small'] != 1){
				$checkboxStr .= $member_data['memname2']."";
			}else{
				$checkboxStr .= "<span style='font-size: 70%;'>".$member_data['memname2']."</span>";
			}
				
			$checkboxStr .= str_repeat("&nbsp;", $space);
			
			$textListStr .= '<span style="color:#'.$member_data['color'].';">■</span>';
			$textListStr .= '['.$member_data['memname3'].']';
			$textListStr .= $member_data['memname2']."\n";
			$textListStr .= str_repeat("&nbsp;", $space);

			$textListStr2 .= '<span style="color:#'.$member_data['color'].';">■</span>';
			$textListStr2 .= '<span style="font-size: 90%;">'.$member_data['memname2']."</span>\n";
			
			$textListStr2 .= str_repeat("&nbsp;", $space);
		}

		switch ($type){
			case 1:
				$returnStr = $checkboxStr;
				break;
			case 2:
				$returnStr = $textListStr;
				break;
			case 3:
				$returnStr = $textListStr2;
				break;
			default:
		}
		return $returnStr;
	}

	function makeCategoryListbox($db, $selected="", $type=1){ //type: 1:Listbox 2:textList(color) 3:textList(color)
		$categoryList = Array();
		$sql  = "SELECT ";
		$sql .= "category.id,";
		$sql .= "categoryname, ";
		$sql .= "category_color.color AS color, ";
		$sql .= "f_disp, ";
		$sql .= "f_calc ";
		$sql .= "FROM category ";
		$sql .= "LEFT OUTER JOIN category_color ";
		$sql .= "ON category_color.id = category.color ";
		$sql .= "ORDER BY dispid ";
		try {
			$result = $db->query($sql);
		} catch (Exception $e) {
			$db->exec("ROLLBACK;");
			echo $e->getTraceAsString();
			return;
		}
		$i=0;
		while( $data = $result->fetch() )  {
			$categoryList[$i]['id'] = $data["id"];
			$categoryList[$i]['categoryname'] = $data["categoryname"];
			$categoryList[$i]['color'] = $data["color"];
			$categoryList[$i]['calc_f'] = $data["f_calc"];
			$categoryList[$i]['f_disp'] = $data["f_disp"];
			$i++;
		}

		switch($type){
			case 1:
				$HeaderStr = "[集計]";
				$NonCategory = "無分類";
				$listStr = "<select name='uni/category'>\n";
				$listStr .= "\t<option value='000'>".$NonCategory."</option>\n";
				for($i=0;$i<count($categoryList);$i++){
					if($categoryList[$i]['f_disp']==1){
						$listStr .= "\t<option value='".$categoryList[$i]['id']."'";
						if($selected == $categoryList[$i]['id']){
							$listStr.=" selected";
						}
						$listStr.= " style='background-color:#".$categoryList[$i]['color']."'>";
						if($categoryList[$i]['calc_f']==1){
							$listStr .= $HeaderStr;
						}
						$listStr.=$categoryList[$i]['categoryname']."</option>\n";
					}
				}
				$listStr .="</select>\n";
				break;
			case 2:
				//not yet
				break;
			case 3:
				//not yet
				break;
		}
		return $listStr;
	}

	function getCategoryColorList($db){ //type: 1:Listbox 2:textList(color) 3:textList(color)
		$categoryList = array();
		$sql  = "SELECT ";
		$sql .= "id,";
		$sql .= "color ";
		$sql .= "FROM category_color ";
		try {
			$result = $db->query($sql);
		} catch (Exception $e) {
			$db->exec("ROLLBACK;");
			echo $e->getTraceAsString();
			return;
		}
		while( $data = $result->fetch() )  {
			$categoryList[$data["id"]] = $data["color"];
		}
		return $categoryList;
	}

	function cvtTimename2RealtimeList($db){
		$sql  = "SELECT ";
		$sql .= "timename, ";
		$sql .= "convert_time ";
		$sql .= "FROM timecvt ";
		
		try {
			$result = $db->query($sql);
		} catch (Exception $e) {
			$db->exec("ROLLBACK;");
			echo $e->getTraceAsString();
			return;
		}
		while( $data = $result->fetch() )  {
			$realtime[$data['timename']] = $data["convert_time"];
		}
		return $realtime;
	}

	function cvtTimename2RealtimeListJP($db){
		$sql  = "SELECT ";
		$sql .= "timename_jp, ";
		$sql .= "convert_time ";
		$sql .= "FROM timecvt ";
		
		try {
			$result = $db->query($sql);
		} catch (Exception $e) {
			$db->exec("ROLLBACK;");
			echo $e->getTraceAsString();
			return;
		}
		while( $data = $result->fetch() )  {
			$realtime[$data['timename_jp']] = $data["convert_time"];
		}
		return $realtime;
	}

	function cvtTimenameJP2ENlist($db){
		$sql  = "SELECT ";
		$sql .= "timename, ";
		$sql .= "timename_jp ";
		$sql .= "FROM timecvt ";
		
		try {
			$result = $db->query($sql);
		} catch (Exception $e) {
			$db->exec("ROLLBACK;");
			echo $e->getTraceAsString();
			return;
		}
		while( $data = $result->fetch() )  {
			$realtime[$data['timename_jp']] = $data["timename"];
		}
		return $realtime;
	}

	function cvtTimename2TimezoneIDList($db){
		$sql  = "SELECT ";
		$sql .= "id, ";
		$sql .= "timename ";
		$sql .= "FROM timecvt ";
		
		try {
			$result = $db->query($sql);
		} catch (Exception $e) {
			$db->exec("ROLLBACK;");
			echo $e->getTraceAsString();
			return;
		}
		while($data = $result->fetch()){
			$realtime[$data['timename']] = $data["id"];
		}
		return $realtime;
	}

	
	function makeRdoChgType($dispChgType = false){
		if($dispChgType){
			$chgStr = "変更";
			$copyStr = "複製";
			$delStr = "削除";
			$rdoStr = "<input type='radio' name='uni/chgtype' value='change' CHECKED>".$chgStr."<input type='radio' name='uni/chgtype' value='copy'>".$copyStr."<input type='radio' name='uni/chgtype' value='delete'>".$delStr;
		}else{
			$rdoStr = "";
		}
		return $rdoStr;
	}

	//週の初めの日付を返す
	function getFirstDayOfWeek($YYYYMMDD, $monorsun = 0){ //monorsun: 0:Sunday 1:Monday
		$weekNumArrayList = Array(0,1,2,3,4,5,6,0,1,2,3,4,5);
		$YYYY=substr($YYYYMMDD,0,4);
		$MM=substr($YYYYMMDD,4,2);
		$DD=substr($YYYYMMDD,6,2);
		$targetDate = mktime(0, 0, 0, $MM, $DD, $YYYY);
		$w = date('w',$targetDate);
		if($w == $monorsun){
			$firstDayOfWeek = $targetDate;
		}else{
			if($monorsun > $w){
				$back = 7;
			}else{
				$back = 0;
			}
			$minus = ($monorsun-$w-$back)." day";
			$firstDayOfWeek = strtotime($minus,$targetDate);
		}
		return $firstDayOfWeek;
	}

	function makeFooterNaviStr($startyear,$endyear){
		$outputStr = "<div class='monthnavi'>";
		for($i=$startyear;$i<=$endyear;$i++){
			$outputStr .= "<a href='../index.php?y=".$i."&weeks=55'>".$i."年</a>&nbsp;";
			for($j=1;$j<=12;$j++){
				$outputStr .= "<a href='../index.php?d=".$i.sprintf("%02d",$j)."01&weeks=6'>".$j."月</a>&nbsp;";
			}
			$outputStr .= "&nbsp;&nbsp;&nbsp;<a href='../index.php?b=".$i."0401-".($i+1)."0331'>FY".$i."</a>";
			$outputStr .= "<br>";
		}
		$outputStr .= "</div>";
		$outputStr = $this->insertIndent($outputStr, 3);
		return $outputStr;
	}
	
	function makeCSVforGoogleCalendar($startdate,$enddate){
		//Subject,Start Date,Start Time,End Date,End Time,All Day Event,Description,Location,Private
		//期末試験,05/12/20,07:10:00 PM,05/12/07,10:00:00 PM,False,"小論文問題（2,000 字）",614 教室,True
	}
	
	function getMemberColorList($db){
		//メンバー色データの取得
		$sql  = "SELECT ";
		$sql .= "id, ";
		$sql .= "color ";
		$sql .= "FROM member_color ";
		$sql .= "ORDER BY id ";

		$member_color = array();
		$result = $db->query($sql);
		while( $data = $result->fetch() )  {
			$member_color[$data["id"]] = $data["color"];
		}
		return $member_color;
	}
	
	function getNewIcon($modified, $f_insert){
		$dayBetween = 3;	//day
		$minBetween = 3;	//min
		$iconstr = "";

		$day1 = time();
		$day2 = strtotime($modified);
		$disp_modified = date("Y/m/d");
		$sa = $day1 - $day2;
		if($sa < ($dayBetween * 24 * 60 * 60)){
			if($f_insert == 0){
				$iconstr = "<img src='../img/up.gif' alt='[up]' title='".$disp_modified."更新'>";
			}else{
				$iconstr = "<img src='../img/new.gif' alt='[new]' title='".$disp_modified."追加'>";
			}
		}
		return $iconstr;
	}

	function dispCopyright($confData){
		$version = "3.0";
		$trypath = "";
		$outputStr = "";

		if(file_exists("../img/unicale_logo_ss.png")){
			$currentpath = "../";
		}elseif(file_exists("img/unicale_logo_ss.png")){
			$currentpath = "./";
		}elseif(file_exists("../index.php")){
			$currentpath = "../";
		}else{
			$currentpath = "./";
		}
		
		if(F_FOOTERDISP == 1){
			$version = UVERSION;
			$v = str_replace(".","",$version);
			$outputStr .= "<span class='footerlogo'><a href='https://www.unicale.com/?v=".$v."'><img src='".$currentpath."img/unicale_logo_ss.png' alt='UNICALE' style='border: none;'></a></span>";
			$outputStr .= "<a href='https://www.unicale.com/?v=".$v."'>UNICALE</a> ver.".$version." - copyright UNICALE Project Team. -";
		}else{
			$outputStr .= "<a href='".$currentpath."index.php'>".$confData->conf["calname"]."</a>";
		}
		return $outputStr;
	}

	function dispRss(){
		$trypath = "";
		$outputStr = "";
		if(file_exists("../img/rss.gif")){
			$currentpath = "../";
		}elseif(file_exists("img/rss.gif")){
			$currentpath = "./";
		}elseif(file_exists("../index.php")){
			$currentpath = "../";
		}else{
			$currentpath = "./";
		}
		$outputStr .= "&nbsp;&nbsp;<a href='".$currentpath."data/index.rdf'><img src='".$currentpath."img/rss.gif' alt='RSS1.0'>&nbsp;RSS1.0</a>";
		
		return $outputStr;
	}


	function dispSearchBox($editable_str){
		$outputStr = "";
		$outputStr .= "\t<div id='search'>\n";
		$outputStr .= "\t\t\t\t<form action='../search.php' method='get'>\n";
		$outputStr .= "\t\t\t\t\t<input type='hidden' name='editable' value='".$editable_str."'>\n";

		$outputStr .= "\t\t\t\t\t<input type='text' name='sk' size='40'><input type='submit' name='search' value='検索'>\n";
		$outputStr .= "\t\t\t\t</form>\n";
		$outputStr .= "\t\t\t</div>\n";
		return $outputStr;
	}

	function findtags($text){
		$findcount = preg_match_all('/#([^#\s]*)/u', $text, $matches);
		return ($matches);
	}
	
	function getTagsArray($db){
		$tags = array();
		$sql  = "SELECT ";
		$sql .= "tagname ";
		$sql .= "FROM tag ";
		$sql .= "ORDER BY tagname ";

		$result = $db->query($sql);
		while( $data = $result->fetch() )  {
			$tags[] = trim($data["tagname"]);
		}
		return $tags;
	}

	function insertIndent($str, $indentCount, $separator="\n"){
		//指定数インデント挿入
		$output_str = trim($str);
		$indent_str = str_repeat("\t", $indentCount);
//		$indent_str = str_repeat("●", $indentCount);
		$output_str = $indent_str.$output_str;
		$indent_str = $separator.$indent_str;
		$output_str = str_replace($separator, $indent_str, $output_str);
		$output_str .= $separator;
		return $output_str;
	}
}

class makeNavi{
	function prevMonth($YYYY,$MM,$DD=1){
		$monthCalc = Array(12, 1, 2, 3, 4, 5, 6, 7, 8, 9,10,11,12, 1);
		$yearCalc = Array(-1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1);

		//PrevMonth
		$PrevMonth = sprintf("%02d",$monthCalc[$MM-1]);
		$PrevMonthYear = $YYYY+$yearCalc[$MM-1];
		$PrevMonthStr = $PrevMonthYear.$PrevMonth."01";
		return $PrevMonthStr;
	}

	function nextMonth($YYYY,$MM,$DD=1){
		$monthCalc = Array(12, 1, 2, 3, 4, 5, 6, 7, 8, 9,10,11,12, 1);
		$yearCalc = Array(-1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1);
		//NextMonth
		$NextMonth = sprintf("%02d",$monthCalc[$MM+1]);
		$NextMonthYear = $YYYY+$yearCalc[$MM+1];
		$NextMonthStr = $NextMonthYear.$NextMonth."01";
		return $NextMonthStr;
	}

	function prevWeek($YYYY,$MM,$DD){
		$targetDate = mktime(0, 0, 0, $MM, $DD, $YYYY);
		//PrevWeek
		$PrevWeekDate = strtotime("-7 day",$targetDate);
		$PrevWeekYYYY = date('Y', $PrevWeekDate);
		$PrevWeekMM = date('m', $PrevWeekDate);
		$PrevWeekDD = date('d', $PrevWeekDate);
		$PrevWeekStr = $PrevWeekYYYY.$PrevWeekMM.$PrevWeekDD;
		return $PrevWeekStr;
	}

	function nextWeek($YYYY,$MM,$DD){
		//NextWeek
		$targetDate = mktime(0, 0, 0, $MM, $DD, $YYYY);
		$NextWeekDate = strtotime("+7 day",$targetDate);
		$NextWeekYYYY = date('Y', $NextWeekDate);
		$NextWeekMM = date('m', $NextWeekDate);
		$NextWeekDD = date('d', $NextWeekDate);
		$NextWeekStr = $NextWeekYYYY.$NextWeekMM.$NextWeekDD;
		return $NextWeekStr;
	}
}


class checkSubmit{
	function sanitize($str) {
	  $str = strip_tags(htmlspecialchars($str));
	  return preg_replace(array('/[~;\'\"]/'), '', $str);
	}
}

class confData{
	public $conf;
	function getConfData($db){

		$sql  = "SELECT ";
		$sql .= "calname, ";
		$sql .= "f_keiji_mode,";
		$sql .= "startyear, ";
		$sql .= "endyear, ";
		$sql .= "disp_category_flat, ";
		$sql .= "monorsun, ";
		$sql .= "monthnavistartmonth, ";
		$sql .= "event_calendar_mode, ";
		$sql .= "f_pickup_disp, ";
		$sql .= "opt1, ";
		$sql .= "opt2, ";
		$sql .= "opt3 ";
		$sql .= "FROM conf ";

		$result = $db->query($sql);
		while( $conf_data = $result->fetch() )  {
			$conf_init["calname"] = $conf_data["calname"];
			$conf_init["f_keiji_mode"] = $conf_data["f_keiji_mode"];
			$conf_init["startyear"] = $conf_data["startyear"];
			$conf_init["endyear"] = $conf_data["endyear"];
			$conf_init["disp_category_flat"] = $conf_data["disp_category_flat"];
			$conf_init["monorsun"] = $conf_data["monorsun"];
			$conf_init["monthnavistartmonth"] = $conf_data["monthnavistartmonth"];
			$conf_init["event_calendar_mode"] = $conf_data["event_calendar_mode"];
			$conf_init["f_pickup_disp"] = $conf_data["f_pickup_disp"];
			$conf_init["opt1"] = $conf_data["opt1"];
			$conf_init["opt2"] = $conf_data["opt2"];
			$conf_init["opt3"] = $conf_data["opt3"];
		}
		$this->conf = $conf_init;
	}
}


class fullSearch{
	function cleanWordText($keyword){
//		$search_keyword = checkSubmit::sanitize($keyword);
		$search_keyword = (new checkSubmit)->sanitize($keyword);
		$search_keyword = str_replace("　"," ",$search_keyword);
		$search_keyword = preg_replace('/ +/',' ', $search_keyword);
		$search_keyword = trim($search_keyword);
		return $search_keyword;
		
	}
	function fullSearchText($db,$keyword){
		$keyword_count = count($keyword);
		$search_data = array();
		if($keyword_count > 0){
			$where_sql = "";
			for($i=0; $i<$keyword_count;$i++){
				if($i != 0){
					$where_sql .= " AND ";
				}
				$where_sql .= "(  ";
				$where_sql .= " title like '%".$keyword[$i]."%' ";
				$where_sql .= " OR detail like '%".$keyword[$i]."%' ";
				$where_sql .= " OR place like '%".$keyword[$i]."%' ";
				$where_sql .= " ) ";
			}

			$sql  = "SELECT ";
			$sql .= "calendar.id, ";
			$sql .= "title,";
			$sql .= "vaguedate_f, ";
			$sql .= "startdate, ";
			$sql .= "starttime, ";
			$sql .= "endtime, ";
			$sql .= "detail, ";
			$sql .= "place, ";
			$sql .= "category.categoryname, ";
			$sql .= "category_color.color AS categorycolor, ";
			$sql .= "timename_jp ";
			$sql .= "FROM ((( calendar ";
			$sql .= "LEFT OUTER JOIN timecvt ";
			$sql .= "ON calendar.starttime_zone = timecvt.id) ";
			
			$sql .= "LEFT OUTER JOIN category ";
			$sql .= "ON calendar.category = category.id) ";
	
			$sql .= "LEFT OUTER JOIN category_color ";
			$sql .= "ON category.color = category_color.id) ";

			$sql .= "WHERE ";
			$sql .= $where_sql;
			$sql .= "ORDER BY startdate DESC, starttime, endtime ";

			$result_counter = 0;
			$result = $db->query($sql);
			while( $data = $result->fetch() )  {
				$search_data[$result_counter]["id"] = $data["id"];
				$search_data[$result_counter]["title"] = $data["title"];
				$search_data[$result_counter]["vaguedate_f"] = $data["vaguedate_f"];
				$search_data[$result_counter]["detail"] = $data["detail"];
				$search_data[$result_counter]["place"] = $data["place"];
				$search_data[$result_counter]["startdate"] = $data["startdate"];
				$search_data[$result_counter]["starttime"] = $data["starttime"];
				$search_data[$result_counter]["endtime"] = $data["endtime"];
				$search_data[$result_counter]["categorycolor"] = $data["categorycolor"];
				$search_data[$result_counter]["categoryname"] = $data["categoryname"];
				$search_data[$result_counter]["title"] = $data["title"];
				
				$search_data[$result_counter]["timename_jp"] = $data["timename_jp"];
				$result_counter++;
			}
			return $search_data;
		}
	}
}

class rssProcess{
	function rssHeader($title,$thisScriptURL,$PublishDate){
		$rssHeader  = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";
		$rssHeader .= "<rdf:RDF xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" xmlns=\"http://purl.org/rss/1.0/\" xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:sy=\"http://purl.org/rss/1.0/modules/syndication/\" xml:lang=\"ja\">\n";
		$rssHeader .= "	<channel rdf:about=\"".$thisScriptURL."\">\n";
		$rssHeader .= "		<title>".$title."</title>\n";
		$rssHeader .= "		<link>".$thisScriptURL."</link>\n";
		$rssHeader .= "		<description />\n";
		$rssHeader .= "		<dc:language>ja</dc:language>\n";
		$rssHeader .= "		<dc:date>".$PublishDate."</dc:date>\n";
		return($rssHeader);
	}

	function putRSS2($db,$baseURL,$rssHeader){
	
		$sql  = "SELECT ";
		$sql .= "calendar_id, ";
		$sql .= "modified, ";
		$sql .= "title, ";
		$sql .= "startdate, ";
		$sql .= "starttime2, ";
		$sql .= "endtime, ";
		$sql .= "f_insert, ";
		$sql .= "place, ";
		$sql .= "members ";
		$sql .= "FROM ";
		$sql .= " calendar_journal ";
		$sql .= "LIMIT 20";
		$result = $db->query($sql);
		$i=0;
		while( $data = $result->fetch() )  {
			$rss_data[$i]["calendar_id"] = $data["calendar_id"];
			$rss_data[$i]["modified"] = $data["modified"];
			$rss_data[$i]["calendar_id"] = $data["calendar_id"];
			$rss_data[$i]["title"] = $data["title"];
			$rss_data[$i]["startdate"] = $data["startdate"];
			$rss_data[$i]["starttime2"] = $data["starttime2"];
			$rss_data[$i]["endtime"] = $data["endtime"];
			$rss_data[$i]["place"] = $data["place"];
			$rss_data[$i]["f_insert"] = $data["f_insert"];
			$rss_data[$i]["members"] = $data["members"];
			$i++;
		}
		//rss用データ加工
		$last20PublishDate = date(DATE_ATOM);

		$rdfLI  = "\t\t<items>\n";
		$rdfLI .= "\t\t\t<rdf:Seq>\n";
		$rdfITEM = "";

		for($i=0; $i<count($rss_data);$i++){
			if($rss_data[$i]["endtime"] != ""){
				$last20Time = $rss_data[$i]["starttime2"]."-".$rss_data[$i]["endtime"];
			}else{
				if($rss_data[$i]["starttime2"] == "未定"){
					$last20Time = "";
				}else{
					$last20Time = $rss_data[$i]["starttime2"];
				}
			}

			$last20Time = $rss_data[$i]["startdate"]." ".$last20Time;
			$last20title = $last20Time." ".$rss_data[$i]["title"];

			if($rss_data[$i]["f_insert"] == 1){
				$last20title = "[追加]".$last20title;
			}else{
				$last20title = "[更新]".$last20title;
			}
			
			if($rss_data[$i]["place"] != ""){
				$last20title .= "(".$rss_data[$i]["place"] .")";
			}
			$thisScriptURL = $baseURL."edit.php";
			$modified = str_replace(" ","T",$rss_data[$i]["modified"] );

			$theYYYYMMDD = str_replace("-","",$rss_data[$i]["startdate"]);

			$last20link = $baseURL."edit.php?id=".$rss_data[$i]["calendar_id"]."&amp;ref=rss";

			$last20Member = $rss_data[$i]["members"];
			$last20description = $rss_data[$i]["members"];

			$rdfLI   .= "\t\t\t<rdf:li rdf:resource=\"".$last20link."\" />\n";
			$rdfITEM .= "\t<item rdf:about=\"".$last20link."\">\n";
			$rdfITEM .= "\t\t<title>".$last20title."</title>\n";
			$rdfITEM .= "\t\t<link>".$last20link."</link>\n";
			$rdfITEM .= "\t\t<description>".$last20description."</description>\n";
			$rdfITEM .= "\t\t<dc:date>".$modified."</dc:date>\n";
			$rdfITEM .= "\t</item>\n";
		}
		$rdfLI .= "\t\t\t</rdf:Seq>\n";
		$rdfLI .= "\t\t</items>\n";
		$rdfLI .= "\t</channel>\n";
		$rssFooter = "</rdf:RDF>";
		$rss = $rssHeader.$rdfLI.$rdfITEM.$rssFooter;

//		if(FILE_LOCK)lock("index.rdf");
		$handle = fopen("../data/index.rdf", 'w');
		if($handle){
			fwrite($handle, $rss);
			fclose($handle);
		}
//		if(FILE_LOCK)unlock("index.rdf");
	}
}


?>