<?php
#event
require_once('../lib/unicom.php');
require_once('../lib/unicomdisp.php');
require_once('../lib/uniview.php');
ini_set('display_errors', DISP_ERR);

if ($_SERVER["REQUEST_METHOD"] === "GET") {
	if(!empty($_GET["op"])){
		$output_target_GET = $_GET["op"];
		switch ($output_target_GET){
			case "jsonp":
				$output_target = 1;
				header("Content-type: application/json; charset=utf-8");
				break;
			case "json":
				$output_target = 2;
				header("Content-type: application/json; charset=utf-8");
				break;
			case "html":
				header("Content-type: text/html; charset=utf-8");
				$output_target = 0;
				break;
			default:
				header("Content-type: text/html; charset=utf-8");
				$output_target = 0;
		}
	}else{
		$output_target = 0;
	}
}

if(!isset($editable)){
	$editable = false;
} 

$db_file = "../data/unicale.db";
$pathinfo = pathinfo(__FILE__);

$basedirTmp = realpath($pathinfo['dirname'])."/";
$root_dir = $basedirTmp;
$basedirTmp = $basedirTmp."data/";
$basedir = $basedirTmp;

$basedir = realpath("../data/");

$thisURL = (empty($_SERVER["HTTPS"]) ? "http://" : "https://") . $_SERVER["HTTP_HOST"] . $_SERVER["REQUEST_URI"];
$thisURLindex = (empty($_SERVER["HTTPS"]) ? "http://" : "https://") . $_SERVER["HTTP_HOST"] . $_SERVER["SCRIPT_NAME"];
$thisURLBase = str_replace("event/calendar.php","",(empty($_SERVER["HTTPS"]) ? "http://" : "https://") . $_SERVER["HTTP_HOST"] . $_SERVER["SCRIPT_NAME"]);

$Keijimsg = "";
$readKeijiFile = "";

$pdo_connection = "sqlite:".$db_file;
if(! $db = new PDO($pdo_connection)){
  die("DB Connection Failed.");
}
$db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
$unicom = new unicom();
$unicomdisp = new unicomdisp();
$uniview = new uniview();
$makeNavi = new makeNavi();
$confData = new confData();
$confData->getConfData($db);

$checkSubmit = new checkSubmit();
$calname = $confData->conf["calname"];
if($confData->conf["startyear"] == ""){
	$startyear = date('Y',time());
}else{
	$startyear = $confData->conf["startyear"];
}
if($confData->conf["endyear"] == ""){
	$endyear = $startyear + 5;
}else{
	$endyear = $confData->conf["endyear"];
}
$monthnavistartmonth = $confData->conf["monthnavistartmonth"];

$dayAdd = 0;
$theDayDatas = array();
$theDays = array();
$theWeekTypes = array();
$theDaysforDisp = array();
$theDaysWeekDisp = array();

$weekStrArrayList = Array("日","月","火","水","木","金","土","日","月","火","水","木","金");
$weekCSSArrayList = Array(   0,   1,   1,   1,   1,   1,   6,   0,   1,   1,   1,   1,   1);
$weekNumArrayList = Array(   0,   1,   2,   3,   4,   5,   6,   0,   1,   2,   3,   4,   5);

$theDayDataOne = array();
$monorsun = $confData->conf["monorsun"]; //0:日曜始まり, 1:月曜始まり Monday or Sunday

$focusDate= "";

if ($_SERVER["REQUEST_METHOD"] === "GET") {
	if(!empty($_GET["mode"])){
		if($_GET["mode"] == "keiji"){
			if($confData->conf["f_keiji_mode"] == 1){
				$unicomdisp->dispKeiji($basedir, "keiji", "", $calname,$unicom,$confData);
			}
		}
	}

	if(!empty($_GET["mode"])){
		if($_GET["mode"] == "keijiwrt"){
			if($confData->conf["f_keiji_mode"] == 1){
				$writePostData = $checkSubmit->sanitize($_GET["keiji"]);
				$Keijimsg = $unicomdisp->dispKeiji($basedir, "keijiwrt", $writePostData, $calname, $unicom,$confData);
			}
		}
	}

	if(!empty($_GET["y"])){ //カレンダーの日付をクリックされた入力の場合
		$dispWeekNum = 55;
	}else{
		$dispWeekNum = 6;
	}
	if(!empty($_GET["weeks"])){ //カレンダーの日付をクリックされた入力の場合
		$dispWeekNum = (int) $_GET["weeks"];
		if($dispWeekNum >=1000){
			$dispWeekNum = 1000;
		}
		if($dispWeekNum <1){
			$dispWeekNum = 1;
		}
	}

	if(!empty($_GET["focus"])){ //カレンダーの日付をクリックされた入力の場合
		$focusDate = $checkSubmit->sanitize($_GET["focus"]);
	}

	if(!empty($_GET["d"])){ //カレンダーの日付をクリックされた入力の場合
		$get_date = $_GET["d"];
		$YYYY = (int) substr($get_date,0,4);
		$MM = (int) substr($get_date,4,2);
		$DD = (int) substr($get_date,6,2);
		try {
			$targetDate = mktime(0, 0, 0, $MM, $DD, $YYYY);
		} catch (Exception $e) {
			$unicom->echsw($output_target, "日付指定に誤りがあります。");
			exit;
		}
		$targetDate = mktime(0, 0, 0, $MM, $DD, $YYYY);
	}elseif(!empty($_GET["y"])){
		$YYYY = (int) $_GET["y"];
		$MM = "01";
		$DD = "01";
		try {
			$targetDate = mktime(0, 0, 0, $MM, $DD, $YYYY);
		} catch (Exception $e) {
			$unicom->echsw($output_target, "日付指定に誤りがあります。");
			exit;
		}
	}elseif(!empty($_GET["b"])){
		$get_betweendates = explode("-",$_GET["b"]); 

		$get_fromdate = $get_betweendates[0];
		$YYYY = (int) substr($get_fromdate,0,4);
		$MM = (int) substr($get_fromdate,4,2);
		$DD = (int) substr($get_fromdate,6,2);
		$get_fromdate = strtotime($YYYY."-".$MM."-".$DD);
		
		$get_todate = $get_betweendates[1];
		$YYYY = (int) substr($get_todate,0,4);
		$MM = (int) substr($get_todate,4,2);
		$DD = (int) substr($get_todate,6,2);
		$get_todate = strtotime($YYYY."-".$MM."-".$DD);
		
		if($get_fromdate < $get_todate){
			$between_days = ($get_todate - $get_fromdate) / (60 * 60 * 24);	//日数の差を計算
			$between_weeks = $between_days / 7 + 1;	//週数の差を計算
			$targetDate = $get_fromdate;
			$dispWeekNum = $between_weeks;
			
		}else{
			$unicom->echsw($output_target, "日付指定に誤りがあります。");
			exit;
		}
	}else{
		$targetDate = time();
	}
	
	$currentYear = date("Y", $targetDate);
	$currentMonth= date("m", $targetDate);
	$currentDay  = date("d", $targetDate);

}else{
	$currentYear = date("Y");
	$currentMonth= date("m");
	$currentDay  = date("d");
}
$currentlastDay = date('d', strtotime('last day of ' . $currentYear."-".$currentMonth));
$today_YYYYMMDD = date("Ymd");
$today_time = date("H:i:s");

$searchStartDate = $currentYear.$currentMonth."01";
$searchEndDate = $currentYear.$currentMonth.$currentlastDay;

$title = $calname;

ob_start();

$uniview->setContent_header_title($unicom->bufsw($output_target, $calname));
if($editable && $confData->conf["event_calendar_mode"]){
	$uniview->setContent_header_inputmode($unicom->bufsw($output_target, "<div class='inputmode'>イベントカレンダー編集モード</div>"));
}


if($confData->conf["f_keiji_mode"] == 1){
	$readKeijiFile = $unicomdisp->getreadKeijiFile($basedir);
}
$uniview->setContent_header_keiji($unicom->bufsw($output_target, "		<div class='msgarea'><span class='msg'>".$Keijimsg."</span></div>"));

if($editable == true){
	$uniview->setContent_header_inputarea($unicom->bufsw($output_target, $unicom->dispHeader($output_target, $readKeijiFile, $db, $startyear, $endyear, $currentYear, $currentMonth, $currentDay)));
}else{
	$uniview->setContent_header_membericons($unicom->bufsw($output_target, $unicom->makeMemberCheckBoxes2($db,0,3)));
}

if($confData->conf["f_pickup_disp"] == 1){
   $uniview->setContent_header_pickup($unicom->bufsw($output_target, "<div class='pickup' style='page-break-after: always;'><div class='pickup_title'>PICKUP</div>".$unicomdisp->readPickup($db,$unicom,$editable)."</div>"));
}

$uniview->setContent_header_todaydate($unicom->bufsw($output_target, "<div class='todaydate'>".$currentYear."年".$currentMonth."月</div>"));

$uniview->setContent_header_navi($unicom->bufsw($output_target, $unicom->dispNavi($makeNavi, $currentYear, $currentMonth, $currentDay, $monthnavistartmonth)));

$outputstr_temp = "";
$outputstr_temp .= "<div class='forprint'>\n";
$outputstr_temp .= $unicom->makeMemberCheckBoxes2($db,0,3);
$outputstr_temp .= "</div>\n";
$uniview->setContent_header_memberCheckBoxes($unicom->bufsw($output_target, $outputstr_temp));


//曜日を表示
$unicom->echsw($output_target, $unicomdisp->dispWeekHeader($monorsun, $weekStrArrayList, $weekNumArrayList, $weekCSSArrayList));

$dayCounter = 0;
$searchTargetDateYYYYMMDD = $currentYear.sprintf('%02d',$currentMonth).sprintf('%02d',$currentDay);
$firstDayOfWeek = $unicom->getFirstDayOfWeek($searchTargetDateYYYYMMDD, 0);

$searchTargetDateYYYYMMDD = date('Y',$targetDate).date('m',$targetDate).date('d',$targetDate);
$firstDayOfWeek = $unicom->getFirstDayOfWeek($searchTargetDateYYYYMMDD, $monorsun);
$targetDate = $firstDayOfWeek;

$holiday_static = $unicomdisp->get_holiday_static($db);
$holiday = $unicomdisp->get_holiday($db);
$event_static = $unicomdisp->get_event_static($db);

$categoryColorList = $unicom->getCategoryColorList($db); //カテゴリー別色リストの取得 [id]color
$categoryColorList[0] = "fefefe";  //カテゴリ無指定時の背景色

$unicom->storeJson($output_target, '[');

//-----------

//カレンダーデータをまとめて取得
$calendar_data = $unicomdisp->getCalendarDataDB($db, $dispWeekNum, $targetDate);

//-----------


$dayAdd = 0;
for($i=0;$i<$dispWeekNum;$i++){
	$event_exist = false;

	$unicom->echsw($output_target, "\t\t<tr>\n");
	for($j=0;$j<7;$j++){
		if($event_exist && ($counter > 0)){
			$unicom->storeJson($output_target, ',');
		}

		$plus = "+".$dayAdd." day";
		$theDay = strtotime($plus,$targetDate);
		$theYYYY = date('Y', $theDay);
		$theMM = date('m', $theDay);
		$theDD = date('d', $theDay);
		$theW = date('w', $theDay);
		$theYYYYMMDD = $theYYYY.$theMM.$theDD;
		$theMMDD = $theMM.$theDD;
		$searchTargetDate = $theYYYY."-".$theMM."-".$theDD;
		
		$unicom->echsw($output_target, "\t\t\t<td>\n");
	

		//祝日の判定
		$holidayInfo = array();
		$holiday_static_exist_f = false;
		$holiday_exist_f = false;
		if (array_key_exists($theMMDD,$holiday_static)){
			$holiday_static_exist_f = true;
			$holiday_static_theMMDD = $holiday_static[$theMMDD];
		}else{
			$holiday_static_theMMDD = '';
		}
		if (array_key_exists($theYYYYMMDD,$holiday)){
			$holiday_exist_f = true;
			$holiday_theYYYYMMDD = $holiday[$theYYYYMMDD];

		}else{
			$holiday_theYYYYMMDD = '';
		}

		if($holiday_static_exist_f || $holiday_exist_f){
			$holidayInfo = $unicomdisp->getHolidaysName(
				$holiday_static_theMMDD,
				$holiday_theYYYYMMDD);
			$holiday_f = $holidayInfo['holiday_f'];
			$holiday_title = $holidayInfo['holidayTitles'][0];
		}else{
			$holiday_f = 0;
			$holiday_title = "";
		}

		$event_static_exit_counter = 0;
		$event_static_date = array();
		$event_static_eventname = array();
		$event_static_url = array();

		$event_static_f = 0;
		for($k=0;$k<count($event_static);$k++){
			if($event_static[$k]['eventdate'] == $theMMDD){
				$event_static_f = 1;
				$event_static_date[$event_static_exit_counter] = $event_static[$k]["eventdate"];
				$event_static_eventname[$event_static_exit_counter] = $event_static[$k]["eventname"];
				$event_static_url[$event_static_exit_counter] = $event_static[$k]["url"];
				$event_static_exit_counter++;
			}
		}
		//日ごと出力データの生成（曜日，祝日判定）

		//曜日ごとのstyle名を取得
		$theWeekType = $unicomdisp->getWeekStyle($theW, $holiday_f);

		//各マスに日を表示
		$unicom->echsw($output_target, $unicomdisp->dispDayString($i, $j, $theWeekType, $theYYYYMMDD, $editable));

		if(strcmp($theYYYYMMDD,$today_YYYYMMDD) == 0){
			$unicom->echsw($output_target, "\t\t\t\t<div class='today'>&nbsp;</div>\n");
		}
		if($theYYYYMMDD == $focusDate){
			$unicom->echsw($output_target, "\t\t\t\t<a name='focus' id='focus'><div class='focus' >&nbsp;</div></a>\n");
		}
		$unicom->echsw($output_target, "\t\t\t\t");

		//祝日の表示
		if($holiday_f == 1){
			$unicom->echsw($output_target, "<span class='holiday'>");
			foreach($holiday_title as $holidayTitleOne){
				$unicom->echsw($output_target, $holidayTitleOne."<br>");
			}
			$unicom->echsw($output_target, "</span>");
		}
		
		//年次固定イベントの表示
		if($event_static_f == 1){
			$unicom->echsw($output_target, "<span class='event_static'>");
			for($k=0;$k<count($event_static_date);$k++){
				if($event_static_url[$k] == ""){
					$unicom->echsw($output_target, $event_static_eventname[$k]."<br>");
				}else{
					$unicom->echsw($output_target, "<a href='".$event_static_url[$k]."'>".$event_static_eventname[$k]."</a><br>");
				}
			}
			$unicom->echsw($output_target, "</span>");
		}

		$counter = 0;
		if(isset($calendar_data[$searchTargetDate])){
			foreach($calendar_data[$searchTargetDate] as $key => $data){

				if($counter >0){
					$unicom->storeJson($output_target, ',');
				}

				$unicom->storeJson($output_target, '{');
				$unicom->storeJson($output_target, '"startdate": '.json_encode(str_replace("-","",$searchTargetDate)).',');

				$calendar_output = "";

				//時刻表示
				$calendar_output .= $unicomdisp->dispTimeString($data);

				//時刻表示をjsonに格納
				$unicom->storeJson($output_target, $unicomdisp->outputTimeStringJson($data));

				//表示用「場所」文字列生成
				$place_str = $unicomdisp->dispPlace($data);

				//Newアイコンの表示
				$calendar_output .= "<span style='margin: 0 1px 0 1px;'>".$unicom->getNewIcon($data["modified"],$data["f_insert"])."</span>";

				//タイトル表示
				$calendar_output .= $data["title"];
				$calendar_output .= $place_str;

				$calendar_id = $data["id"];

				if($data['color'] != ''){
					$category_color = $categoryColorList[$data['color']];
				}else{
					$category_color = '';
				}
				
				$one_calendar_data = $calendar_output;
				if(!empty($data["detail"])){
					$exist_detail = "...";
				}else{
					$exist_detail = "";
				}
				$exturl = str_replace("calendar/calendar.php","",$thisURLBase);

				//予定データとリンクの生成

				switch($output_target){
					case 1:	//jsonp
					case 2:	//json
						if($editable){
							$one_calendar_data = "<a class='c2' href='".$exturl."calendar/edit.php?id=".$calendar_id."'>".$one_calendar_data.$exist_detail."</a>";
						}else{
							$one_calendar_data = $one_calendar_data.$exist_detail;
						}
						break;
					default:
					if($editable){
						$one_calendar_data = "<a class='c2' href='../calendar/edit.php?id=".$calendar_id."'>".$one_calendar_data.$exist_detail."</a>";
					}else{
						$one_calendar_data = $one_calendar_data.$exist_detail;
					}
				}

				//silent（ひっそり）の時，控えめなcssを適用
				if($data["silent"] == 1){
					$one_calendar_data = "<span class='silent'>".$one_calendar_data ."</span>";
				}

				//メンバーデータの取得
				$member_result = $unicomdisp->getMemberData($db, $calendar_id);
				$member_output = "";
				$member_output2 = "";
				$tooltip_member = "";
				while( $member_data = $member_result->fetch() )  {
					$member_output .= "&nbsp;<span class='ui-corner-all membericon' style='background-color:#".$member_data["color"]."; white-space: nowrap;'>".$member_data["memname3"]."</span>";
					$tooltip_member .= "[".$member_data["memname2"]."]";
					$member_output2 .= "&nbsp;<span class='ui-corner-all membericon' style='background-color:#".$member_data["color"].";  font-size: 100%; line-height: 1.5em; white-space: nowrap;'>".$member_data["memname2"]."</span>";
				}

				$member_output2 = $member_output;


				$tooltip_detail = mb_substr($data["detail"], 0, 200, "utf-8");
	//				$tooltip_text = $tooltip_member.$tooltip_detail;
				$tooltip_text_chack = $member_output2.$tooltip_detail;

				if(!empty($tooltip_text_chack)){
					$tooltip_text = $member_output2."<br>".$tooltip_detail;
	//					$one_calendar_data = "<div class='tooltip'>". $one_calendar_data . "<span class='tooltiptext'>".$tooltip_text."</span></div>";
					$one_calendar_data = "<div class='tooltip'>". $one_calendar_data . "<span class='tooltiptext' style='text-align: left;'>".$tooltip_text."</span></div>";
				}

	//				$one_calendar_data = "<div class='tooltip'>". $one_calendar_data . "<span class='tooltiptext'>".$data["detail"]."</span></div>";
				$one_calendar_data = $one_calendar_data.$member_output;

				
				//カテゴリー背景色の適用
				$one_calendar_data = "<span class='c1' style='background-color:#".$category_color.";border-radius:5px;	margin: 2px 2px 0.4em 2px;'>".$one_calendar_data."</span>";
				$one_calendar_data .= "\n";
				$one_calendar_data .= "\t\t\t\t";

				if($data["silent"] == 1){
					$one_calendar_data = "<span class='silent'>".$one_calendar_data."</span>";
				}

				$unicom->echsw($output_target, $one_calendar_data);
				
				$unicom->storeJson($output_target, '"html":'.json_encode($one_calendar_data));
				$unicom->storeJson($output_target, '}');
				$counter++;
			}
		}

		$unicom->echsw($output_target, "&nbsp;");
		$dayAdd++;
		$unicom->echsw($output_target, "\n");

		$unicom->echsw($output_target, "<div id='ext_".$theYYYYMMDD."'></div>");

		$unicom->echsw($output_target, "\t\t\t</td>\n");
		if($counter > 0){
			$event_exist = true;
		}
	}
	$unicom->echsw($output_target, "\t\t</tr>\n");
	$unicom->outputJsonString = rtrim($unicom->outputJsonString, ",");
}

$unicom->outputJsonString = str_replace("}\n,\n]","}\n]",$unicom->outputJsonString);
$unicom->outputJsonString = str_replace("}\n{","},\n{",$unicom->outputJsonString);
$unicom->outputJsonString = rtrim($unicom->outputJsonString, ",");
$unicom->storeJson($output_target, ']');
$unicom->outputJsonString = str_replace("}\n,\n]","}\n]",$unicom->outputJsonString);

if($output_target == 1){	//jsonp
	$unicom->outputJsonString = "caldata(".$unicom->outputJsonString.");";
}
$unicom->echsw($output_target, "\t</table>\n");
$unicom->echsw($output_target, "</div>\n");

if($editable){
	$editable_str = "true";
}else{
	$editable_str = "false";
}
$uniview->setContent_footer_searchBox($unicom->bufsw($output_target,$unicom->dispSearchBox($editable_str)));
$uniview->setContent_footer_memberCheckBoxes($unicom->bufsw($output_target, $unicom->makeMemberCheckBoxes2($db,0,3)));
$uniview->setContent_footer_navi($unicom->bufsw($output_target, $unicom->makeFooterNaviStr($startyear,$endyear)));
if($editable){
	$uniview->setContent_footer_menu($unicom->bufsw($output_target, makeFooterMenuString()));
}
$uniview->setContent_footer_copyright($unicom->bufsw($output_target, $unicom->dispCopyright($confData)));
$uniview->setContent_footer_rss($unicom->bufsw($output_target, $unicom->dispRss()));

$sendparamToJs = $_SERVER['QUERY_STRING'];

$unicom->echsw($output_target, "<input type='hidden' id='sendparamToJs' value='".$sendparamToJs."'>\n");
$unicom->echsw($output_target, "<script>dispExtCaldata()</script>\n");


switch($output_target){
	case 1:	//jsonp
	case 2:	//json
		ob_end_clean();
		echo($unicom->outputJsonString);
		break;
	case 0:
	default:
		$uniview->setTitle($title);
		$uniview->setRedirect_url("");
		$uniview->setRelativePath("../");		
		$uniview->setContent(ob_get_clean());
		$uniview->showc();
}

//------------------

function makeFooterMenuString(){
    $footerMenuString = "";
    $footerMenuString .= "<div class='footer3'>\n";
    $footerMenuString .= "\t<a href='../admin/admin_conf.php'>設定</a>";
    $footerMenuString .= "&nbsp;&nbsp;|&nbsp;&nbsp;";
    $footerMenuString .= "\t<a href='../admin/admin_member.php'>メンバー管理</a>&nbsp;";
    $footerMenuString .= "&nbsp;&nbsp;|&nbsp;&nbsp;";
    $footerMenuString .= "\t<a href='../admin/admin_category.php'>カテゴリ管理</a>";
    $footerMenuString .= "&nbsp;&nbsp;|&nbsp;&nbsp;";
    $footerMenuString .= "\t<a href='../admin/admin_data.php'>データインポートエクスポート</a>";
    $footerMenuString .= "</div>\n";
    return $footerMenuString;
}

?>
