<?php
require_once('../lib/unicom.php');
ini_set('display_errors', DISP_ERR);

if (! $db = new PDO("sqlite:../data/unicale.db")) {
  die("DB Connection Failed.");
}
$db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
$unicom = new unicom();
$checkSubmit = new checkSubmit();
$confData = new confData();

$confData->getConfData($db);
$calname = $confData->conf["calname"];

$error_f = 0;

?>
<html>
	<head>
		<link rel="stylesheet" type="text/css" href="../css/ucal_common.css"  media="all">
		<link rel="stylesheet" type="text/css" href="../css/ucalp.css" media="print">
		<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
		<link type="text/css" href="../js/jquery-ui-1.12.1.custom/jquery-ui.theme.min.css" rel="Stylesheet" />
		<script type="text/javascript" src="../js/jquery-3.2.1.min.js"></script>
		<script type="text/javascript" src="../js/jquery-ui-1.12.1.custom/jquery-ui.js"></script>
		<script src="../js/jquery-simplecolorpicker-master/jquery.simplecolorpicker.js"></script>
		<link rel="stylesheet" href="../js/jquery-simplecolorpicker-master/jquery.simplecolorpicker.css">

		<title><?php echo $calname; ?>メンバー管理</title>
	</head>

	<body>
	<div id="pageimage">
<?php

$member_colnames = array(
	'id',				 //0
	'表示順',			  //1
	'フルネーム',			//2
	'短縮名1',   //3
	'短縮名2',	//4
	'アイコン色',			//5
	'アイコン画像',  //6
	'縮小表示',			 //7
	'表示する',			 //8
	'備考',			 //9
	'スペース数',			 //10
	'',	   //11
	'',	   //12
	''		//13
);
$member_colnames_second = array(
	'',				 //0
	'',			  //1
	'',			//2
	'（2文字程度）',   //3
	'（1文字程度）',	//4
	'',			//5
	'（未実装）',  //6
	'',			 //7
	'',			 //8
	'',			 //9
	'このメンバーの<br>表示後に空ける<br>スペース数',	//10
	'(将来拡張用1)',	   //11
	'(将来拡張用2)',	   //12
	'(将来拡張用3)'		//13
);
$member_colnames_required = array(
	0,		//0
	1,		//1
	1,		//2
	1,		//3
	1,		//4
	1,		//5
	0,		//6
	1,		//7
	1,		//8
	0,		//9
	0,		//10
	0,		//11
	0,		//12
	0		//13
);

$max_member = 100;
$max_icon = 10;

if ($_SERVER["REQUEST_METHOD"] === "POST") {
	for($i=0; $i<$max_member; $i++){
		$update_id = 0;
		$update_dispid = "";
		$update_memname1 = "";
		$update_memname2 = "";
		$update_memname3 = "";
		$update_color = "";
		$update_icon = "";
		$update_f_small = 0;
		$update_f_disp = 0;
		$update_bikou = "";
		$update_space = 0;
		$update_opt1 = "";
		$update_opt2 = "";
		$update_opt3 = "";
		$error_f = 0;
		$error_msg = "";
		for($j=0; $j<=12; $j++){
			switch($j){
				case 0: //id
					$update_id = $i+1;
					break;
				case 1: //dispid
					$temp_arg = "uni/dispid_".($i+1);
					if(!empty($_POST[$temp_arg])){
						$update_dispid = (int) $_POST[$temp_arg];
					}
					break;
				case 2:
					$temp_arg = "uni/memname1_".($i+1);
					if(!empty($_POST[$temp_arg])){
						$update_memname1 = $checkSubmit->sanitize($_POST[$temp_arg]);
					}
					break;

				case 3:
					$temp_arg = "uni/memname2_".($i+1);
					if(!empty($_POST[$temp_arg])){
						$update_memname2 = $checkSubmit->sanitize($_POST[$temp_arg]);
					}
					break;

				case 4:
					$temp_arg = "uni/memname3_".($i+1);
					if(!empty($_POST[$temp_arg])){
						$update_memname3 = $checkSubmit->sanitize($_POST[$temp_arg]);
					}
					break;
				case 5:
					$temp_arg = "uni/color_".($i+1);
					if(!empty($_POST[$temp_arg])){
						$update_color = (int) $_POST[$temp_arg];
					}
					break;
				case 6:
					$temp_arg = "uni/icon_".($i+1);
					if(!empty($_POST[$temp_arg])){
						$update_icon = (int) $_POST[$temp_arg];
					}
					break;
				case 7:
					$temp_arg = "uni/f_small_".($i+1);
					if(!empty($_POST[$temp_arg])){
						$update_f_small = (int) $_POST[$temp_arg];
					}
					break;
				case 8:
					$temp_arg = "uni/f_disp_".($i+1);
					if(!empty($_POST[$temp_arg])){
						$update_f_disp = (int) $_POST[$temp_arg];
					}
					break;
				case 9:
					$temp_arg = "uni/bikou_".($i+1);
					if(!empty($_POST[$temp_arg])){
						$update_bikou = $checkSubmit->sanitize($_POST[$temp_arg]);
					}
					break;
				case 10:
					$temp_arg = "uni/space_".($i+1);
					if(!empty($_POST[$temp_arg])){
						$update_space = (int) $_POST[$temp_arg];
					}
					break;
					
				case 11:
					$temp_arg = "uni/opt1_".($i+1);
					if(!empty($_POST[$temp_arg])){
						$update_opt1 = $checkSubmit->sanitize($_POST[$temp_arg]);
					}
					break;
				case 12:
					$temp_arg = "uni/opt2_".($i+1);
					if(!empty($_POST[$temp_arg])){
						$update_opt2 = $checkSubmit->sanitize($_POST[$temp_arg]);
					}
					break;
				case 13:
					$temp_arg = "uni/opt3_".($i+1);
					if(!empty($_POST[$temp_arg])){
						$update_opt3 = $checkSubmit->sanitize($_POST[$temp_arg]);
					}
					break;
			}
		}
		//エラー条件の判定
		if( !empty($update_memname1) && !empty($update_memname2) && !empty($update_memname3)){
			/*
			if(empty($update_dispid)){
				$error_f =1;
				$error_msg .= "表示順の欄の値が異常です。<br>";
			}
			*/
			if(($update_dispid == 0)||empty($update_dispid)){
				$update_dispid = 1;
			}
			
			
			if(empty($update_color) || ($update_color==0)){
				$error_f =1;
				$error_msg .= "色を選んでください。<br>";
			}
			
			
			if($update_f_small == 1){
			}elseif($update_f_small == 0){
			}else{
				$error_f =1;
				$error_msg .= "縮小表示するかしないかを選んでください。<br>";
			}

			if($update_f_disp == 1){
			}elseif($update_f_disp == 0){
			}else{
				$error_f =1;
				$error_msg .= "表示するかしないかを選んでください。<br>";
			}
			
		}else{
			
			if( !empty($update_memname1) || !empty($update_memname2) || !empty($update_memname3) ){
				if( trim($update_memname1.$update_memname2.$update_memname3) == ""){
					$error_f =1;
					$error_msg .= "メンバー名は，フルネーム，短縮名1，短縮名2のすべてを入力してください。<br>";
				}
			}
		}
		$update_f = 0;
		if(($error_f ==0) &&( !empty($update_memname1) && !empty($update_memname2) && !empty($update_memname3))){
			$update_f = 1;  //更新か挿入を実施する
		}

		if($update_f == 1){
			//メンバーデータの取得
			$sql  = "SELECT ";
			$sql .= "COUNT(id) AS hit ";
			$sql .= "FROM member ";
			$sql .= "WHERE id = ".$update_id ." ";
			
			$result = $db->query($sql);
			$member_exist = 0;
			while( $member_hit = $result->fetch() )  {
				$member_exist = $member_hit["hit"];
			}
			if($member_exist > 0){
				//UPDATE
				$sql  = "UPDATE member SET ";
				$sql .= "dispid = ".$update_dispid.",";
				$sql .= "memname1 = '".$update_memname1."',";
				$sql .= "memname2 = '".$update_memname2."',";
				$sql .= "memname3 = '".$update_memname3."',";
				$sql .= "color = ".$update_color.",";
				$sql .= "f_small = ".$update_f_small.",";
				$sql .= "f_disp = ".$update_f_disp.",";
				$sql .= "bikou = '".$update_bikou."',";
				$sql .= "space = '".$update_space."',";
				$sql .= "opt1 = '".$update_opt1."',";
				$sql .= "opt2 = '".$update_opt2."',";
				$sql .= "opt3 = '".$update_opt3."' ";
				$sql .= " WHERE ";
				$sql .= "id = ".$update_id;

				$db->exec('begin');
				try {
					$db->exec($sql);
					$db->exec('commit');

				} catch (Exception $e) {
					$db->exec("ROLLBACK;");
					echo $e->getTraceAsString();
					return;
				}
//				echo("UPDATED");
				
			}else{
			 //INSERT
				$sql  = "INSERT INTO member (";
				$sql .= "id,";
				$sql .= "dispid,";
				$sql .= "memname1,";
				$sql .= "memname2,";
				$sql .= "memname3,";
				$sql .= "color,";
				$sql .= "f_small,";
				$sql .= "f_disp,";
				$sql .= "bikou,";
				$sql .= "space,";
				$sql .= "opt1,";
				$sql .= "opt2,";
				$sql .= "opt3 ";
				$sql .= ") VALUES ( ";
				$sql .= " ".$update_id.",";
				$sql .= " ".$update_dispid.",";
				$sql .= " '".$update_memname1."',";
				$sql .= " '".$update_memname2."',";
				$sql .= " '".$update_memname3."',";
				$sql .= " ".$update_color.",";
				$sql .= " ".$update_f_small.",";
				$sql .= " ".$update_f_disp.",";
				$sql .= " '".$update_bikou."',";
				$sql .= " '".$update_space."',";
				$sql .= " '".$update_opt1."',";
				$sql .= " '".$update_opt2."',";
				$sql .= " '".$update_opt3."' ";
				$sql .= ") ";
				$db->exec('begin');
				try {
					$db->exec($sql);
					$db->exec('commit');

				} catch (Exception $e) {
					$db->exec("ROLLBACK;");
					echo $e->getTraceAsString();
					return;
				}
//				echo("INSERTED");

				
			}
		}else{
//			echo("追加更新処理を行いません。");
		}
		
	}
}
echo("<h1 class='headerh1'><a href='../index.php'>".$calname."</a></h1>");
echo("<h2><span class='marker'>&#x2756;</span>&nbsp;メンバー管理</h2>");
		
if($error_f != 0){
	echo("<div class='error_msg'>".$error_msg."<div>");
}
?>

<form action="admin_member.php" method="post">
<?php

	
//メンバーデータの取得
$sql  = "SELECT ";
$sql .= "id, ";
$sql .= "dispid,";
$sql .= "memname1, ";
$sql .= "memname2, ";
$sql .= "memname3, ";
$sql .= "color, ";
$sql .= "icon, ";
$sql .= "f_small, ";
$sql .= "f_disp, ";
$sql .= "bikou, ";
$sql .= "space, ";
$sql .= "opt1, ";
$sql .= "opt2, ";
$sql .= "opt3 ";
$sql .= "FROM member ";
$sql .= "ORDER BY id ";
// echo($sql);

$member_init = array();
$result = $db->query($sql);
while( $member_data = $result->fetch() )  {
	$member_init[$member_data["id"]]["dispid"] = $member_data["dispid"];
	$member_init[$member_data["id"]]["memname1"] = $member_data["memname1"];
	$member_init[$member_data["id"]]["memname2"] = $member_data["memname2"];
	$member_init[$member_data["id"]]["memname3"] = $member_data["memname3"];
	$member_init[$member_data["id"]]["color"] = $member_data["color"];
	$member_init[$member_data["id"]]["icon"] = $member_data["icon"];
	$member_init[$member_data["id"]]["f_small"] = $member_data["f_small"];
	$member_init[$member_data["id"]]["f_disp"] = $member_data["f_disp"];
	$member_init[$member_data["id"]]["bikou"] = $member_data["bikou"];
	$member_init[$member_data["id"]]["space"] = $member_data["space"];
	$member_init[$member_data["id"]]["opt1"] = $member_data["opt1"];
	$member_init[$member_data["id"]]["opt2"] = $member_data["opt2"];
	$member_init[$member_data["id"]]["opt3"] = $member_data["opt3"];
}

//メンバー色データの取得
$member_color = $unicom->getMemberColorList($db);
	
echo("<table class='admin1'>");
echo("<thead>");
echo("<tr>");
	for($i=0;$i<14;$i++){
		switch ($i){
			case 6:
				break;
			default:
				echo("<th>");
				echo($member_colnames[$i]);
				echo("<br>");
				echo("<span class='member_colnames_second'>");
				echo($member_colnames_second[$i]);
				echo("</span>");
				echo(disp_required($member_colnames_required,$i));
				echo("</th>");
				break;
		}
	}
echo("</tr>");
echo("</thead>");
echo("<tbody>");
for($i=1;$i<=$max_member;$i++){
	echo("<tr>");
	for($j=0;$j<14;$j++){
		if($j != 6){	//アイコン表示設定は非表示
			//初期値設定
			if(isset($member_init[$i])){
				$init_dispid = $member_init[$i]["dispid"];
				$init_memname1  = $member_init[$i]["memname1"];
				$init_memname2  = $member_init[$i]["memname2"];
				$init_memname3  = $member_init[$i]["memname3"];
				$init_color	 = $member_init[$i]["color"];
				$init_icon	  = $member_init[$i]["icon"];
				$init_f_small   = $member_init[$i]["f_small"];
				$init_f_disp	= $member_init[$i]["f_disp"];
				$init_bikou	 = $member_init[$i]["bikou"];
				$init_space	 = $member_init[$i]["space"];
				$init_opt1	  = $member_init[$i]["opt1"];
				$init_opt2	  = $member_init[$i]["opt2"];
				$init_opt3	  = $member_init[$i]["opt3"];
			}else{
				$init_dispid = 0;
				$init_memname1  = "";
				$init_memname2  = "";
				$init_memname3  = "";
				$init_color	 = "";
				$init_icon	  = "";
				$init_f_small   = "";
				$init_f_disp	= "";
				$init_bikou	 = "";
				$init_space	 = "";
				$init_opt1	  = "";
				$init_opt2	  = "";
				$init_opt3	  = "";
			}


			echo("<td>");
			switch($j){
				case 0:
					echo($i);
					break;
				case 1:
					echo("<select name='uni/dispid_".$i."'>");
					for($k=0; $k<$max_member; $k++){
						if($k == $init_dispid){
							$dispid_selected = " SELECTED";
						}else{
							$dispid_selected = "";
						}
						echo("<option value='".$k."' ".$dispid_selected.">".$k."</option>");
					}
					echo("</select>");
					break;
				case 2:
					echo("<input type='text' name='uni/memname1_".$i."' value='".$init_memname1."' size='16'>");
					break;
				case 3:
					echo("<input type='text' name='uni/memname2_".$i."' value='".$init_memname2."' size='6'>");
					break;
				case 4:
					echo("<input type='text' name='uni/memname3_".$i."' value='".$init_memname3."' size='4'>");
					break;
				case 5:
					echo("<select name='uni/color_".$i."' id='unicolor_".$i."' onChange='changeColor(this, ".$i.");'>");
					
					$selected_color = "";
					for($k=0; $k<$max_member; $k++){
						if($k == $init_color){
							$color_selected = " SELECTED";
							$selected_color = $member_color[$k];
						}else{
							$color_selected = "";
						}
						echo("<option value='".$k."' style='background-color:#".$member_color[$k].";' ".$color_selected.">".$member_color[$k]."</option>");
	//					echo("<option value='#".$member_color[$k]."' ".$color_selected.">".$member_color[$k]."</option>");
					}
					echo("</select>");
					echo("<span id='unicoloricon_".$i."' class='coloricon' style='background-color:#".$selected_color.";'>&nbsp;&nbsp;&nbsp;</span>");
	//				echo("<input type='text' name='member_color_selected_".$k."' value='".$init_color."'>");
	//				echo("<div class='color'>7</div>");

					break;
				case 6:
					/*
					echo("<select name='uni/icon_".$i."'>");
					for($k=0; $k<$max_icon; $k++){
						echo("<option value='".$k."' >icon".$k."</option>");
					}
					echo("</select>");
					*/
					break;
				case 7:
					if($init_f_small == 1){
						$checked_f_small = " checked='CHECKED'";
					}else{
						$checked_f_small = "";
					}
					echo("<input type='checkbox' name='uni/f_small_".$i."' value='1' ".$checked_f_small.">");
					break;
				case 8:
					if($init_f_disp == 1){
						$checked_f_disp = " checked='CHECKED'";
					}else{
						$checked_f_disp = "";
					}
					echo("<input type='checkbox' name='uni/f_disp_".$i."' value='1' ".$checked_f_disp.">");
					break;
				case 9:
					echo("<input type='text' name='uni/bikou_".$i."' value='".$init_bikou."' size='12'>");
					break;

				case 10:
					echo("<input type='text' name='uni/space_".$i."' value='".$init_space."' size='4'>");
					break;

				case 11:
					echo("<input type='text' name='uni/opt1_".$i."' value='".$init_opt1."' size='8'>");
					break;
				case 12:
					echo("<input type='text' name='uni/opt2_".$i."' value='".$init_opt2."' size='8'>");
					break;
				case 13:
					echo("<input type='text' name='uni/opt3_".$i."' value='".$init_opt3."' size='8'>");
					break;
			}
			echo("</td>");
		}
	}
	echo("</tr>");
}
echo("</tbody>");
echo("</table>");
?>
<br>
<input type="submit" value="更新" class="ui-button ui-corner-all button">
<br>
<br>
<span class="normal">※メンバーデータは，削除できません。不必要なメンバー情報は「表示する」のチェックを外して非表示にしてください。</span>
<script>
function changeColor(obj, selectid){
	var colorIconId = "unicoloricon_" + selectid;
	document.getElementById(colorIconId).style.backgroundColor = '#'+obj.options[obj.selectedIndex].text;
}
</script>
<?php
echo("</form>");


//$db->close();
$db = null;

echo("<span class='normal'><a class='button' href='../index.php'>トップページへ戻る</a></span>");
$unicom->dispCopyright($confData);
$unicom->dispRss();
echo("</div>");
echo("</body>");
echo("</html>");


function disp_required($member_colnames_required,$checkcol){
	if($member_colnames_required[$checkcol] == 1){
		$outputString = "<span class='col_required'>必須</span>";
	}else{
		$outputString = "";
	}
	return $outputString;
}
	 
?>
