<?php

set_time_limit(1800);


if(file_exists('./d.php')){
	require_once('./d.php');
	disp_mode_msg();
}

require_once('../lib/unicom.php');
ini_set('display_errors', DISP_ERR);

require_once('./import_init_data.php');

if (! $db = new PDO("sqlite:../data/unicale.db")) {
  die("DB Connection Failed.");
}
$db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
$unicom = new unicom();
$makeNavi = new makeNavi();
$confData = new confData();
$import_init_data = new import_inidata();
$checkSubmit = new checkSubmit();

$confData->getConfData($db);
$calname = $confData->conf["calname"];
if(ANNONYMOUS_MODE == 1){
	$uname = $calname;
}else{
	$uname = "UNICALE";
}

$webroot = str_replace("admin_data.php","",$_SERVER["PHP_SELF"]);
$webdataroot = str_replace("admin/admin_data.php","",$_SERVER["PHP_SELF"])."data/";
$basedir = realpath(__DIR__."/../data/");

$realtime_list = $unicom->cvtTimename2RealtimeList($db);
$realtime_list_JP = $unicom->cvtTimename2RealtimeListJP($db);
$realtime_list_JPEN = $unicom->cvtTimenameJP2ENlist($db);
$realtime_list_ID = $unicom->cvtTimename2TimezoneIDList($db);

if(!isset($_GET["directimport"])){
	$directimport = 0;
}else{
	$directimport = 1;
}

?>
<html>
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=utf-8"> 
	<link rel="stylesheet" type="text/css" href="../css/ucal_common.css"  media="all">
	<link rel="stylesheet" type="text/css" href="../css/ucalp.css" media="print">
	<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
	<link type="text/css" href="../js/jquery-ui-1.12.1.custom/jquery-ui.theme.min.css" rel="Stylesheet" />
	<script type="text/javascript" src="../js/jquery-3.2.1.min.js"></script>
	<script type="text/javascript" src="../js/jquery-ui-1.12.1.custom/jquery-ui.js"></script>
	<title><?php echo $calname; ?>データインポートエクスポート</title>
	<style>
		.import_area{
			margin: 0 auto 1em;
			text-align: left;
			padding: 0.5em;
			background-color: #fffbf0;
			border: 1px solid #f8c4c4;
			width: 800px;
		}
		.import_area .paragraph{
			font-size: 80%;
			margin: 1em;
			text-align: left;
		}
		.path{
			margin: 0.5em;
			border: #f8acac 1px solid;
			background-color: antiquewhite;
			padding: 0.5em;
		}
		.filename{
			margin: 0;
			border-bottom: #f8acac 2px dotted;
			padding: 0;
		}
		.import_area h2{
			border-left: #f7aaaa solid 3px;
			padding: 0.5em 0.5em 0.5em 1em;
/*
			background-color: #fdfdfd;
*/
		}
		
	</style>
</head>
<body>

<?php
	
if(($_SERVER["REQUEST_METHOD"] === "POST")||($directimport == 1)){
	//ver0.3系統からのインポート
//	if (!empty($_POST["u03url"]) && !empty($_POST["u03import"])){
	if (!empty($_POST["u03import"])||!empty($_POST["u03importnew"])){
		if(!empty($_POST["u03importnew"])){
			$sql  = "DELETE FROM calendar ";
			$db->exec($sql);
			$sql  = "DELETE FROM calendar_member ";
			$db->exec($sql);
			$sql  = "DELETE FROM member ";
			$db->exec($sql);
		}

		touch("../data/import/03/export_utf8.csv");
		touch("../data/import/03/config_utf8.php");

		$eventdata_path      = realpath("../data/import/03/export.csv");
		$eventdata_utf_path  = realpath("../data/import/03/export_utf8.csv");
		$memberdata_path     = realpath("../data/import/03/config.php");
		$memberdata_utf_path = realpath("../data/import/03/config_utf8.php");
		
		//イベントデータをShift-JISからutf8へ変換
		$msg = convertCode($eventdata_path, "sjis", $eventdata_utf_path, "UTF-8", "\n");
		

		$file = new NoRewindIterator( new SplFileObject( $eventdata_utf_path ));
		$file->setFlags(SplFileObject::READ_CSV);

		//メンバーデータをeucからutf8へ変換
		$msg = convertCode($memberdata_path, "eucJP-win", $memberdata_utf_path, "UTF-8", "\n");
		require($memberdata_utf_path);
		
		$importfullMemberlist = fullMemberList();
	
		$import_member_count = count($importfullMemberlist);

		//メンバーIDの最大値を取得
		$sql  = "SELECT MAX(id) AS maxid FROM member; ";
		$result_memberid = $db->query($sql);
		while( $maxid = $result_memberid->fetch() )  {
			$max_member_id = $maxid["maxid"];
		}

		for($i=0;$i<$import_member_count;$i++){
			 //INSERT
			$update_id = $max_member_id+$i+1;
			$update_dispid = $i+1;
			$update_memname1 = $importfullMemberlist[$i][2];
			$update_memname2 = $importfullMemberlist[$i][1];
			$update_memname3 = $importfullMemberlist[$i][4];
			$update_color	= $i+1;
			$update_f_small = (int) $importfullMemberlist[$i][6];
			$update_f_disp  = (int) $importfullMemberlist[$i][3];
			$update_bikou = "import";
			$update_space = (int) $importfullMemberlist[$i][5];
			$update_opt1 = "";
			$update_opt2 = "";
			$update_opt3 = "";
			
			$sql  = "INSERT INTO member (";
			$sql .= "id,";
			$sql .= "dispid,";
			$sql .= "memname1,";
			$sql .= "memname2,";
			$sql .= "memname3,";
			$sql .= "color,";
			$sql .= "f_small,";
			$sql .= "f_disp,";
			$sql .= "bikou,";
			$sql .= "space,";
			$sql .= "opt1,";
			$sql .= "opt2,";
			$sql .= "opt3 ";
			$sql .= ") VALUES ( ";

			$sql .= " ".$update_id.",";
			$sql .= " ".$update_dispid.",";
			$sql .= " '".$update_memname1."',";
			$sql .= " '".$update_memname2."',";
			$sql .= " '".$update_memname3."',";
			$sql .= " ".$update_color.",";
			$sql .= " ".$update_f_small.",";
			$sql .= " ".$update_f_disp.",";
			$sql .= " '".$update_bikou."',";
			$sql .= " ".$update_space.",";
			$sql .= " '".$update_opt1."',";
			$sql .= " '".$update_opt2."',";
			$sql .= " '".$update_opt3."' ";
			$sql .= ") ";
			
			$inserted_memberlist_memname2[$update_id] = $update_memname2;
			$inserted_memberlist_ID[$update_memname2] = $update_id;
			
			$db->exec('begin');
			try {
				$db->exec($sql);
				$db->exec('commit');

			} catch (Exception $e) {
				$db->exec("ROLLBACK;");
				echo $e->getTraceAsString();
				return;
			}
		}

//	try {
//		$db->exec('begin');

// 0:No,1:FileID,2:日付,3:時間種別,4:開始時刻,5:終了時刻,6:イベント情報,7:場所,8:メンバー,9:ジャンル,10:イベント詳細,11:ひっそり,
// 12:拡張用1,13:拡張用2,14:拡張用3,15:拡張用4,16:拡張用5,17:人数,18:時間,19:工数
		$i = 0;
		$insert_data = array();
		$Char2CodeList = getChar2CodeList();
		$members_str = "";

		foreach ($file as $line) {
			if(($i>0) && (trim($line[0] != NULL))){
//				for($j=0;$j<13;$j++){
//					$line[$j] = cvtSJIS2UTF8($line[$j]);
//				}

				$members_data = array();
				$insert_data[$i]["startdate"] = str_replace("/","-",$line[2]); 
				if($line[3] == "時間指定"){
					$insert_data[$i]["starttime"] = str_replace(":","",$line[4]);
					$insert_data[$i]["starttime_real"] = $insert_data[$i]["starttime"];
					$insert_data[$i]["endtime"] = str_replace(":","",$line[5]);
					$insert_data[$i]["vaguedate_f"] = 0;
					$insert_data[$i]["starttime_zone"] = 0;
				}else{
					$starttime_jp = $line[3];
					if($starttime_jp != NULL){
						$starttime_EN = $realtime_list_JPEN[$starttime_jp];
					}else{
						$starttime_EN = "";
					}
					$insert_data[$i]["starttime"] = $starttime_EN;

					if($starttime_jp != NULL){
						$insert_data[$i]["starttime_real"] = $realtime_list[$starttime_EN];
					}else{
						$insert_data[$i]["starttime_real"] = "";
					}
					$insert_data[$i]["endtime"] = "";
					$insert_data[$i]["vaguedate_f"] = 1;

					if($starttime_jp != NULL){
						$insert_data[$i]["starttime_zone"] = $realtime_list_ID[$starttime_EN];
					}else{
						$insert_data[$i]["starttime_zone"] = "";
					}
					if($insert_data[$i]["starttime_zone"] == ''){
						$insert_data[$i]["starttime_zone"] = 0;
					}
				}

				$insert_data[$i]["title"] = $line[6];
				$insert_data[$i]["title"] = str_replace("'","",$insert_data[$i]["title"]);
				$insert_data[$i]["title"] = str_replace(",","，",$insert_data[$i]["title"]);
				
				$insert_data[$i]["place"] = $line[7];
				$insert_data[$i]["place"] = str_replace("'","",$insert_data[$i]["place"]);
				$insert_data[$i]["place"] = str_replace("'","",$insert_data[$i]["place"]);

				$temp_members = $line[8];
				$temp_members = str_replace("]",",",$temp_members);
				$temp_members = str_replace("[","",$temp_members);
				$temp_members = rtrim($temp_members,",");
				$members_str .= ",". $temp_members;
				$members_data[$i]["member"] = explode(",",$temp_members);
				$insert_data[$i]["member"] = $members_data[$i]["member"];
				$insert_data[$i]["category"] = $line[9];
				$temp_detail = replaceChar2Code($line[10]);
				$insert_data[$i]["detail"] = $temp_detail;

				if($line[11] == 1){
					$insert_data[$i]["silent"] = 1;
				}else{
					$insert_data[$i]["silent"] = 0;
				}

				$i++;
			}else{
				$i++;
			}
		}

//		STEP1
		//メンバーの追加
		$members_array1 = explode(",",$members_str);
		
//		STEP2
		$members_array1 = array_unique($members_array1);

//		STEP3
		//キーを振り直す
		$members_array1 = array_values($members_array1);

//		STEP4
		//仮メンバーIDを振る
		$member_counter = 0;
		foreach($members_array1 as $members_array1One){
			if(!empty($members_array1One)){
				$members_array2[$member_counter] = $members_array1One;
				$member_counter++;
			}
		}

		$max_lines = $i-1;
		for($i=1;$i<$max_lines;$i++){

			$query_startdate = $insert_data[$i]["startdate"];
			$vaguedate_f = $insert_data[$i]["vaguedate_f"];  //vaguedate_f
			$post_starttime = $insert_data[$i]["starttime"]; //starttime
			$post_endtime = $insert_data[$i]["endtime"]; //endtime
			$post_starttime_zone = $insert_data[$i]["starttime_zone"];
			$post_starttime_real = $insert_data[$i]["starttime_real"];
			$post_title = $insert_data[$i]["title"]; //title
			$post_detail = $insert_data[$i]["detail"]; //detail
			$post_place = $insert_data[$i]["place"]; //place
			$post_category = $insert_data[$i]["category"];  //category
			$post_silent = $insert_data[$i]["silent"];  //silent

			//カレンダーデータの追加
			$sql  = "INSERT INTO calendar( ";
			$sql .= "startdate,";
			$sql .= "datemode,";
			$sql .= "vaguedate_f,";
			$sql .= "enddate,";
			$sql .= "starttime,";
			$sql .= "endtime,";
			$sql .= "starttime_zone,";
			$sql .= "starttime_real,";
			$sql .= "title,";
			$sql .= "detail,";
			$sql .= "member,";
			$sql .= "place,";
			$sql .= "category,";
			$sql .= "silent,";
			$sql .= "level,";
			$sql .= "usehour,";
			$sql .= "modified,";
			$sql .= "opt1,";
			$sql .= "opt2,";
			$sql .= "opt3";
			$sql .= ") VALUES (";
			$sql .= "'".$query_startdate."',";
			$sql .= "0,";  //datemode
			$sql .= $vaguedate_f.",";  //vaguedate_f
			$sql .= "'',"; //enddate
			$sql .= "'".$post_starttime."',"; //starttime
			$sql .= "'".$post_endtime."',"; //endtime
			$sql .= " ".$post_starttime_zone.","; 
			$sql .= "'".$post_starttime_real."',"; 
			$sql .= "'".$post_title."',"; //title
			$sql .= "'".$post_detail."',"; //detail
			$sql .= "'',"; //member
			$sql .= "'".$post_place."',"; //place
			$sql .= "0,";  //category
//			$sql .= "".$post_category.",";  //category
			$sql .= $post_silent.",";  //silent
			$sql .= "0,";  //level
			$sql .= "0,";  //usehour
			$sql .= "'',"; //modified
			$sql .= "'',"; //opt1
			$sql .= "'',"; //opt2
			$sql .= "''	"; //opt3
			$sql .= ")";
			
			$sql = preg_replace('/((?:(?!\\\\).)?(?:\\\\\\\\)*)(\\\\n)/us', '\1'."\n", $sql);

			$db->exec('begin');
			try {
				$db->exec($sql);
				$changed_startdate = $query_startdate;

				//INSERTしたカレンダーデータのIDを取得
				$sql  = "SELECT id FROM calendar WHERE ROWID = last_insert_rowid(); ";
				$inserted_id = 0;

				$result_id = $db->query($sql);
				while( $inserted = $result_id->fetch() )  {
					$inserted_id = $inserted["id"];
				}

				//メンバーカレンダーデータの追加 //important
					$temp_counter = count($insert_data[$i]["member"]);
					if($temp_counter>0){
						foreach($insert_data[$i]["member"] as $member_name_One){
							$memberIDOne = $inserted_memberlist_ID[$member_name_One];
							$sql  = "INSERT INTO calendar_member( ";
							$sql .= "calendar_id,";
							$sql .= "member_id ";
							$sql .= ") VALUES (";
							$sql .= " ".$inserted_id.",";
							$sql .= " ".$memberIDOne." ";
							$sql .= ") ";
							if(!empty($memberIDOne)){
								$db->query($sql);
							}
						}
					}
				$db->exec('commit');

			} catch (Exception $e) {
				$db->exec("ROLLBACK;");
				echo $e->getTraceAsString();
				return;
			}
		}
		echo("<br>");
		echo($import_member_count."件のメンバーデータインポート終了");
		echo("<br>".$i."件のカレンダーイベントデータインポート終了");
		$msg = $import_member_count."件のメンバーデータインポート終了。".$i."件のインポート終了。";
		redirectJS($msg);

	}elseif(!empty($_POST["u20import"])){

		$baseurl = "";
		$d_data_path = realpath("../data/import/20/d_data.txt");
		$d_member_path = realpath("../data/import/20/d_member.txt");
		$d_genre_path = realpath("../data/import/20/d_genre.txt");
		
		
		//予定データの読み込み
		$line_counter = 0;
		echo("読み込みを行っています。<br>");
		echo("<table border=1>");
		$file = fopen($d_data_path,"r");
		
		while (!feof($file)) {
			$Oneline = fgets($file);
			if(trim($Oneline) != ""){
				echo("<tr>");
				switch ($line_counter){
					case 0:
						$line_header = explode(",",$Oneline);
							echo("<td>line_counter</td>");
							for($i=0;$i<19;$i++){
								echo("<td>".$line_header[$i]."</td>");
							}
						break;
					case 1:
						break;
					default:
						$line = explode("##SEP##",$Oneline);
						if (!empty($line)){
							echo("<td>".$line_counter."</td>");
							for($i=0;$i<19;$i++){
								$fullEventslist[$line_counter-2][$line_header[$i]] = $line[$i];
								echo("<td>".$fullEventslist[$line_counter-2][$line_header[$i]]."</td>");
							}
						}
						break;
				}
				echo("</tr>");
				$line_counter++;
			}
		}
		echo("</table>");
		fclose($file);
		
		$max_events = $line_counter - 3;
		if($max_events < 0){
			$max_events = 0;
		}
		echo($max_events."件のイベントデータがあります。");
		//予定データの読み込みここまで
		
		
		//メンバーデータの読み込み
		$line_counter = 0;
		echo("<table border=1>");
		$file = fopen($d_member_path,"r");
		
		while (!feof($file)) {
			$Oneline = fgets($file);
			if(trim($Oneline) != ""){
				echo("<tr>");
				switch ($line_counter){
					case 0:
						$line_header = explode(",",$Oneline);
							echo("<td>line_counter</td>");
							for($i=0;$i<19;$i++){
								echo("<td>".$line_header[$i]."</td>");
							}
						break;
					case 1:
						break;
					default:
						$line = explode("##SEP##",$Oneline);
						if (!empty($line)){
							echo("<td>".$line_counter."</td>");
							for($i=0;$i<19;$i++){
								$fullMemberlist[$line_counter-2][$line_header[$i]] = $line[$i];
								echo("<td>".$fullMemberlist[$line_counter-2][$line_header[$i]]."</td>");
							}
						}
						break;
				}
				echo("</tr>");
				$line_counter++;
			}
		}
		echo("</table>");
		fclose($file);
		
		$max_members = $line_counter - 2;
		if($max_members < 0){
			$max_members = 0;
		}
		echo($max_members."件のメンバーデータがあります。");
		//メンバーデータの読み込みここまで


		//カテゴリ（ジャンル）データの読み込み
		$line_counter = 0;
		echo("<table border=1>");
		$file = fopen($d_genre_path,"r");
		
		while (!feof($file)) {
//			$line= $file_->fgetcsv("\t");
			$Oneline = fgets($file);
			if(trim($Oneline) != ""){
				echo("<tr>");
				switch ($line_counter){
					case 0:
						$line_header = explode(",",$Oneline);
							echo("<td>line_counter</td>");
							for($i=0;$i<19;$i++){
								echo("<td>".$line_header[$i]."</td>");
							}
						break;
					case 1:
						break;
					default:
						$line = explode("##SEP##",$Oneline);
						if (!empty($line)){
							echo("<td>".$line_counter."</td>");
							for($i=0;$i<19;$i++){
								$fullGenrelist[$line_counter-2][$line_header[$i]] = $line[$i];
								echo("<td>".$fullGenrelist[$line_counter-2][$line_header[$i]]."</td>");
							}
						}
						break;
				}
				echo("</tr>");
				$line_counter++;
			}
		}
		echo("</table>");
		fclose($file);
		$max_genre = $line_counter - 2;
		if($max_genre < 0){
			$max_genre = 0;
		}
		echo($max_genre."件のカテゴリ（ジャンル）データがあります。");
		//カテゴリ（ジャンル）データの読み込みここまで

		
		//メンバーデータの作成・挿入
		//メンバーIDの最大値を取得
		$sql  = "SELECT MAX(id) AS maxid FROM member; ";
		$result_memberid = $db->query($sql);
		while( $maxid = $result_memberid->fetch() )  {
			$max_member_id = $maxid["maxid"];
			echo("<br>新メンバーデータのmaxid=".$max_member_id."<br>");
		}

		$import_max_members = $max_members;
		$update_id = 0;


		for($i=0;$i<$max_members;$i++){
			 //INSERT
			$update_old_id = $fullMemberlist[$i]["id"];
			$update_id = $max_member_id+$i+1;
			$update_dispid = $fullMemberlist[$i]["dispid"]+1;
			$update_memname1 = $fullMemberlist[$i]["memname1"];
			$update_memname2 = $fullMemberlist[$i]["memname2"];
			$update_memname3 = $fullMemberlist[$i]["memname3"];
			$update_color	= $i+1;
			
			if($fullMemberlist[$i]["f_small"] == "true"){
				$update_f_small = 1;
			}else{
				$update_f_small = 0;
			}
			if($fullMemberlist[$i]["f_disp"] == "true"){
				$update_f_disp = 1;
			}else{
				$update_f_disp = 0;
			}
			$update_bikou = "import from 2.0x";
			$update_space = (int) $fullMemberlist[$i]["space"];
			$update_opt1 = "";
			$update_opt2 = "";
			$update_opt3 = "";
			
			$sql  = "INSERT INTO member (";
			$sql .= "id,";
			$sql .= "dispid,";
			$sql .= "memname1,";
			$sql .= "memname2,";
			$sql .= "memname3,";
			$sql .= "color,";
			$sql .= "f_small,";
			$sql .= "f_disp,";
			$sql .= "bikou,";
			$sql .= "space,";
			$sql .= "opt1,";
			$sql .= "opt2,";
			$sql .= "opt3 ";
			$sql .= ") VALUES ( ";

			$sql .= " ".$update_id.",";
			$sql .= " ".$update_dispid.",";
			$sql .= " '".$update_memname1."',";
			$sql .= " '".$update_memname2."',";
			$sql .= " '".$update_memname3."',";
			$sql .= " ".$update_color.",";
			$sql .= " ".$update_f_small.",";
			$sql .= " ".$update_f_disp.",";
			$sql .= " '".$update_bikou."',";
			$sql .= " ".$update_space.",";
			$sql .= " '".$update_opt1."',";
			$sql .= " '".$update_opt2."',";
			$sql .= " '".$update_opt3."' ";
			$sql .= ") ";
			
			$inserted_memberlist_ID[$update_old_id] = $update_id;
			$update_id++;

			$db->exec('begin');
			try {
				$db->exec($sql);
				$db->exec('commit');

			} catch (Exception $e) {
				$db->exec("ROLLBACK;");
				echo $e->getTraceAsString();
				return;
			}
			echo("INSERTED");
		}
		//メンバーデータの作成・挿入ここまで


		//カテゴリデータの作成・挿入
		//カテゴリIDの最大値を取得
		$sql  = "SELECT MAX(id) AS maxid FROM category; ";
		$result_categoryid = $db->query($sql);
		while( $maxid = $result_categoryid->fetch() )  {
			$max_category_id = $maxid["maxid"];
			echo("<br>新カテゴリデータのmax_category_id=".$max_category_id."<br>");
		}

		$import_max_category = $max_genre;
		$update_id = 0;
		
		for($i=0;$i<$max_genre;$i++){
			 //INSERT
			$update_old_id = $fullGenrelist[$i]["id"];
			$update_id = $max_category_id + $i + 1;
			$update_dispid = $fullGenrelist[$i]["dispid"]+1;
			$update_categoryname = $fullGenrelist[$i]["genrename"];
			$update_color	= $i+1;
			
			if((trim($fullGenrelist[$i]["f_calc"]) == "true")||($fullGenrelist[$i]["f_calc"] == 1)){
				$update_f_calc = 1;
			}else{
				$update_f_calc = 0;
			}
			if((trim($fullGenrelist[$i]["f_disp"]) == "true")||($fullGenrelist[$i]["f_disp"] == 1)){
				$update_f_disp = 1;
			}else{
				$update_f_disp = 0;
			}
			
			$sql  = "INSERT INTO category (";
			$sql .= "id,";
			$sql .= "dispid,";
			$sql .= "categoryname,";
			$sql .= "color,";
			$sql .= "f_calc,";
			$sql .= "f_disp ";
			$sql .= ") VALUES ( ";

			$sql .= " ".$update_id.",";
			$sql .= " ".$update_dispid.",";
			$sql .= " '".$update_categoryname."',";
			$sql .= " ".$update_color.",";
			$sql .= " ".$update_f_calc.",";
			$sql .= " ".$update_f_disp." ";
			$sql .= ") ";
			
//			$inserted_memberlist_memname2[$update_id] = $update_memname2;
			$inserted_categorylist_ID[$update_old_id] = $update_id;
			$update_id++;

			$db->exec('begin');
			try {
				$db->exec($sql);
				$db->exec('commit');

			} catch (Exception $e) {
				$db->exec("ROLLBACK;");
				echo $e->getTraceAsString();
				return;
			}
			echo("INSERTED");
		}
		//カテゴリデータの作成・挿入ここまで

		//イベントデータの挿入(for 2.0)
		$max_lines = $i-1;
		for($i=0;$i<$max_events;$i++){

			if($fullEventslist[$i]["vaguedate_f"] == 0){
				$fullEventslist[$i]["starttime"] = str_replace(":","",$fullEventslist[$i]["starttime"]);
				$fullEventslist[$i]["starttime_real"] = $fullEventslist[$i]["starttime"];
				$fullEventslist[$i]["endtime"] = str_replace(":","",$fullEventslist[$i]["endtime"]);
				$fullEventslist[$i]["vaguedate_f"] = 0;
				$fullEventslist[$i]["starttime_zone"] = 0;
			}else{
				//$fullEventslist[$i]["starttime"] = str_replace(":","",$fullEventslist[$i]["starttime"]);

				$insert_data[$i]["starttime_real"] = $realtime_list[$fullEventslist[$i]["starttime"]];
				$fullEventslist[$i]["endtime"] = "";
				$fullEventslist[$i]["vaguedate_f"] = 1;
				$fullEventslist[$i]["starttime_zone"] = $realtime_list_ID[$fullEventslist[$i]["starttime"]];
				if($fullEventslist[$i]["starttime_zone"] == ''){
					$fullEventslist[$i]["starttime_zone"] = 0;
				}
			}
			
			$query_startdate = substr($fullEventslist[$i]["startdate"],0,4)."-".substr($fullEventslist[$i]["startdate"],4,2)."-".substr($fullEventslist[$i]["startdate"],6,2);
			
			$vaguedate_f = $fullEventslist[$i]["vaguedate_f"];  //vaguedate_f
			$post_starttime = $fullEventslist[$i]["starttime"]; //starttime
			$post_endtime = $fullEventslist[$i]["endtime"]; //endtime
			$post_starttime_zone = $fullEventslist[$i]["starttime_zone"];
			$post_starttime_real = $fullEventslist[$i]["starttime_real"];
			$post_title = $fullEventslist[$i]["title"]; //title
			$post_detail = $fullEventslist[$i]["detail"]; //detail
			$post_place = $fullEventslist[$i]["place"]; //place
			$inserted_categorylist_ID[$fullEventslist[$i]["genre"]] = (int) $inserted_categorylist_ID[$fullEventslist[$i]["genre"]];
			$post_category = $inserted_categorylist_ID[$fullEventslist[$i]["genre"]];  //category
			$post_silent = $fullEventslist[$i]["silent"];  //silent

			//sampleデータ異常によるバグ回避
			if($post_silent == "ALL1"){
				$post_silent = 0;
			}else{
				$post_silent = (int) $post_silent;
			}

			//カレンダーデータの追加
			$sql  = "INSERT INTO calendar( ";
			$sql .= "startdate,";
			$sql .= "datemode,";
			$sql .= "vaguedate_f,";
			$sql .= "enddate,";
			$sql .= "starttime,";
			$sql .= "endtime,";
			$sql .= "starttime_zone,";
			$sql .= "starttime_real,";
			$sql .= "title,";
			$sql .= "detail,";
			$sql .= "member,";
			$sql .= "place,";
			$sql .= "category,";
			$sql .= "silent,";
			$sql .= "level,";
			$sql .= "usehour,";
			$sql .= "modified,";
			$sql .= "opt1,";
			$sql .= "opt2,";
			$sql .= "opt3";
			$sql .= ") VALUES (";
			$sql .= "'".$query_startdate."',";
			$sql .= "0,";  //datemode
			$sql .= $vaguedate_f.",";  //vaguedate_f
			$sql .= "'',"; //enddate
			$sql .= "'".$post_starttime."',"; //starttime
			$sql .= "'".$post_endtime."',"; //endtime
			$sql .= " ".$post_starttime_zone.","; 
			$sql .= "'".$post_starttime_real."',"; 
			$sql .= "'".$post_title."',"; //title
			$sql .= "'".$post_detail."',"; //detail
			$sql .= "'',"; //member
			$sql .= "'".$post_place."',"; //place
			$sql .= $post_category.",";  //category
			$sql .= $post_silent.",";  //silent
			$sql .= "0,";  //level
			$sql .= "0,";  //usehour
			$sql .= "'',"; //modified
			$sql .= "'',"; //opt1
			$sql .= "'',"; //opt2
			$sql .= "''	"; //opt3
			$sql .= ")";
			
			$sql = preg_replace('/((?:(?!\\\\).)?(?:\\\\\\\\)*)(\\\\n)/us', '\1'."\n", $sql);

			$db->exec('begin');
			try {
				$db->exec($sql);
				$changed_startdate = $query_startdate;

				//INSERTしたカレンダーデータのIDを取得
				$sql  = "SELECT id FROM calendar WHERE ROWID = last_insert_rowid(); ";
				$inserted_id = 0;

				$result_id = $db->query($sql);
				while( $inserted = $result_id->fetch() )  {
					$inserted_id = $inserted["id"];
				}


				//メンバーカレンダーデータの追加 //important
				$members_array20 = explode(",",$fullEventslist[$i]["member"] );
					$temp_counter = count($members_array20);
					if($temp_counter>0){
						foreach($members_array20 as $member_name_One){
							$memberIDOne = $inserted_memberlist_ID[$member_name_One];
							$sql  = "INSERT INTO calendar_member( ";
							$sql .= "calendar_id,";
							$sql .= "member_id ";
							$sql .= ") VALUES (";
							$sql .= " ".$inserted_id.",";
							$sql .= " ".$memberIDOne." ";
							$sql .= ") ";
							if(!empty($memberIDOne)){
								$db->query($sql);
							}
						}
					}
				$db->exec('commit');

			} catch (Exception $e) {
				$db->exec("ROLLBACK;");
				echo $e->getTraceAsString();
				return;
			}
		}
		echo("<br>");
		echo($max_member."件のメンバーデータインポート終了");
		echo("<br>".$i."件のカレンダーイベントデータインポート終了");
		$msg = $max_members."件のメンバーデータインポート終了。".$i."件のイベントインポート終了。".$max_genre."件のジャンル（カテゴリ）インポート終了。";
		echo("挿入END");

		redirectJS($msg);

	///////////////////////
	//CSVインポート処理	
	///////////////////////

	}elseif(!empty($_POST["csvimport"])||!empty($_POST["csvimportform"])||($directimport == 1)){
		$csvdata_path = realpath("../data/import/csv/import.csv");
		if(!empty($_POST["csvimportform"])){
			$import_data = $_POST["uni/importdata"];
			$import_data = str_replace("'","",$import_data);
			$import_data = str_replace('"','',$import_data);
			$import_data = str_replace('¥','¥¥',$import_data);
			file_put_contents($csvdata_path,$import_data);
		}
		
		if($_GET["directimport"]==1){
			$csvdata_path = realpath("../data/import/csv/importdemo.csv");
			file_put_contents($csvdata_path,$import_data);
		}
		
		$file = new NoRewindIterator(new SplFileObject($csvdata_path));
		$file->setFlags(SplFileObject::READ_CSV);

//日付,開始時刻,終了時刻,イベントタイトル,イベント詳細,場所,メンバーID,カテゴリ

		$i = 0;
		$insert_data = array();
		foreach ($file as $line) {
			$members_data = array();
			$insert_data[$i]["startdate"] = str_replace("/","-",$line[0]);
			$insert_data[$i]["starttime"] = str_replace(":","",$line[1]);
			if(empty($insert_data[$i]["starttime"])){
				$insert_data[$i]["starttime"] = "ALL1";
			}
			switch ($insert_data[$i]["starttime"]){
				case "AM":
				case "PM":
				case "ALL1":
				case "ALL2":
					$insert_data[$i]["vaguedate_f"] = 1;
					$insert_data[$i]["starttime_real"] = $realtime_list[$insert_data[$i]["starttime"]];
					$insert_data[$i]["starttime_zone"] = $realtime_list_ID[$insert_data[$i]["starttime"]];
					$insert_data[$i]["endtime"] = str_replace(":","",$line[2]);
					break;
				default:
					$insert_data[$i]["vaguedate_f"] = 0;
					$insert_data[$i]["starttime_real"] = substr($insert_data[$i]["starttime"],0,2).":".substr($insert_data[$i]["starttime"],2,2);
					$insert_data[$i]["starttime_zone"] = 0;
					$insert_data[$i]["endtime"] = str_replace(":","",$line[2]);
			}
			
			$insert_data[$i]["title"] = $checkSubmit->sanitize($line[3]);
			$insert_data[$i]["title"] = str_replace("'","",$insert_data[$i]["title"]);
			$insert_data[$i]["title"] = str_replace(",","，",$insert_data[$i]["title"]);
			$insert_data[$i]["title"] = str_replace('"','',$insert_data[$i]["title"]);

			$insert_data[$i]["detail"] = $checkSubmit->sanitize($line[4]);
			$insert_data[$i]["detail"] = str_replace("'","",$insert_data[$i]["detail"]);
			$insert_data[$i]["detail"] = str_replace(",","，",$insert_data[$i]["detail"]);
			$insert_data[$i]["detail"] = str_replace('"','',$insert_data[$i]["detail"]);

			$insert_data[$i]["place"] = $checkSubmit->sanitize($line[5]);
			$insert_data[$i]["place"] = str_replace("'","",$insert_data[$i]["place"]);
			$insert_data[$i]["place"] = str_replace(",","，",$insert_data[$i]["place"]);
			$insert_data[$i]["place"] = str_replace('"','',$insert_data[$i]["place"]);

			$temp_members = $line[6];
			$temp_members = trim($temp_members);
			$members_data[$i]["member"] = explode(" ",$temp_members);
			$insert_data[$i]["memberID"] = $members_data[$i]["member"];
			$insert_data[$i]["category"] = (int) $line[7];

			$i++;
		}

		if($_GET["directimport"] == 1){
			$sql  = "DELETE FROM calendar ";
			$db->exec($sql);
			$sql  = "DELETE FROM calendar_member ";
			$db->exec($sql);			
		}
		
		$max_lines = $i;
		for($i=0;$i<$max_lines;$i++){

			$query_startdate = $insert_data[$i]["startdate"];
			$vaguedate_f = $insert_data[$i]["vaguedate_f"];  //vaguedate_f
			$post_starttime = $insert_data[$i]["starttime"]; //starttime
			$post_endtime = $insert_data[$i]["endtime"]; //endtime
			$post_starttime_zone = $insert_data[$i]["starttime_zone"];
			$post_starttime_real = $insert_data[$i]["starttime_real"];
			$post_title = $insert_data[$i]["title"]; //title
			$post_detail = $insert_data[$i]["detail"]; //detail
			$post_place = $insert_data[$i]["place"]; //place
			$post_category = $insert_data[$i]["category"];  //category

			//カレンダーデータの追加
			$sql  = "INSERT INTO calendar( ";
			$sql .= "startdate,";
			$sql .= "datemode,";
			$sql .= "vaguedate_f,";
			$sql .= "enddate,";
			$sql .= "starttime,";
			$sql .= "endtime,";
			$sql .= "starttime_zone,";
			$sql .= "starttime_real,";
			$sql .= "title,";
			$sql .= "detail,";
			$sql .= "member,";
			$sql .= "place,";
			$sql .= "category,";
			$sql .= "silent,";
			$sql .= "level,";
			$sql .= "usehour,";
			$sql .= "modified,";
			$sql .= "opt1,";
			$sql .= "opt2,";
			$sql .= "opt3";
			$sql .= ") VALUES (";
			$sql .= "'".$query_startdate."',";
			$sql .= "0,";  //datemode
			$sql .= $vaguedate_f.",";  //vaguedate_f
			$sql .= "'',"; //enddate
			$sql .= "'".$post_starttime."',"; //starttime
			$sql .= "'".$post_endtime."',"; //endtime
			$sql .= " ".$post_starttime_zone.","; 
			$sql .= "'".$post_starttime_real."',"; 
			$sql .= "'".$post_title."',"; //title
			$sql .= "'".$post_detail."',"; //detail
			$sql .= "'',"; //member
			$sql .= "'".$post_place."',"; //place
//			$sql .= "0,";  //category
			$sql .= "".$post_category.",";  //category
			$sql .= "0,";  //silent
			$sql .= "0,";  //level
			$sql .= "0,";  //usehour
			$sql .= "'',"; //modified
			$sql .= "'',"; //opt1
			$sql .= "'',"; //opt2
			$sql .= "''	"; //opt3
			$sql .= ")";
			
			$sql = preg_replace('/((?:(?!\\\\).)?(?:\\\\\\\\)*)(\\\\n)/us', '\1'."\n", $sql);

			$db->exec('begin');
			try {
				$db->exec($sql);
				$changed_startdate = $query_startdate;

				//INSERTしたカレンダーデータのIDを取得
				$sql  = "SELECT id FROM calendar WHERE ROWID = last_insert_rowid(); ";
				$inserted_id = 0;

				$result_id = $db->query($sql);
				while( $inserted = $result_id->fetch() )  {
					$inserted_id = $inserted["id"];
				}

				//メンバーカレンダーデータの追加 //important
				if(!empty($insert_data[$i]["memberID"][0])){
					$temp_counter = count($insert_data[$i]["memberID"]);
				}else{
					$temp_counter = 0;
				}

				if($temp_counter>0){
					foreach($insert_data[$i]["memberID"] as $memberIDOne){
						$sql  = "INSERT INTO calendar_member( ";
						$sql .= "calendar_id,";
						$sql .= "member_id ";
						$sql .= ") VALUES (";
						$sql .= " ".$inserted_id.",";
						$sql .= " ".$memberIDOne." ";
						$sql .= ") ";
						if(!empty($memberIDOne)){
							$db->query($sql);
						}
					}
				}
				$db->exec('commit');

			} catch (Exception $e) {
				$db->exec("ROLLBACK;");
				echo $e->getTraceAsString();
				return;
			}
		}
		echo("<br>");
		echo("<br>".$i."件のカレンダーイベントデータインポート終了");
		$msg = $import_member_count."件のメンバーデータインポート終了。".$i."件のインポート終了。";
		redirectJS($msg);		
		
		
		
		
		
	}elseif(!empty($_POST["dbcopy"])){
		echo("<br>");
		echo("dbコピー");
		
		$YYYYMMDDHHIISS = date('Ymdhis');
		$filepath = realpath($basedir."/unicale.db");
		$filepath_dest = realpath($basedir."/unicale_".$YYYYMMDDHHIISS.".db");
		copy ($filepath,$filepath_dest);
		$msg = "dbファイルは/data/unicale_".$YYYYMMDDHHIISS.".dbと言う名前でコピーされました。";
		redirectJS($msg);
		

	}elseif(!empty($_POST["holiday_import"])){
		echo("<br>");
		echo("祝日データのインポート");
		
		$filepath = realpath($basedir."/import/holiday.csv");
		$tablename = "holiday";
		$import_init_data->import_holiday($db,$filepath,$tablename);
		$msg = "祝日データのインポート終了";
		redirectJS($msg);
		
	}elseif(!empty($_POST["event_static_import"])){
		echo("<br>");
		echo("固定イベントデータのインポート");

		$tablename = "event_static";
		$filepath = realpath($basedir."/import/event_static.csv");
		$import_init_data->import_event_static($db,$filepath,$tablename);
		$msg = "固定イベントデータのインポート終了";
		redirectJS($msg);

	}elseif(!empty($_POST["holiday_static_import"])){
		echo("<br>");
		echo("固定休日データのインポート");

		$tablename = "holiday_static";
		$filepath = realpath($basedir."/import/holiday_static.csv");
		$import_init_data->import_holiday($db,$filepath,$tablename);
		$msg = "固定休日データのインポート終了";
		redirectJS($msg);

	
	}elseif(!empty($_POST["memcolor_import"])){
		echo("<br>");
		echo("メンバー色データのインポート");
		$filepath = realpath($basedir."/import/member_color.csv");
		$tablename = "member_color";
		$import_init_data->import_color($db,$filepath,$tablename);
		$msg = "メンバー色データのインポート終了";
		redirectJS($msg);
		
	}elseif(!empty($_POST["categorycolor_import"])){
		echo("<br>");
		echo("カテゴリー色データのインポート");
		$filepath = realpath($basedir."/import/category_color.csv");
		$import_init_data->edit_tags($db,$filepath,$tablename);
		$msg = "カテゴリー色データのインポート終了";
		redirectJS($msg);

	}elseif(!empty($_POST["edittags"])){
		$input_tags = array();
		echo("<br>");
		echo("タグの編集");
		if(!empty($_POST["uni/tags"])){
			$input_tags = explode("\n", $_POST["uni/tags"]);
			$input_tags = array_values(array_unique($input_tags));
		}
		$sql  = "DELETE FROM tag; ";
		$db->exec($sql);
		
		foreach ($input_tags as $tag) {
			if(trim($tag) != ""){
				$sql  = "INSERT INTO tag( ";
				$sql .= "tagname";
				$sql .= ") VALUES (";
				$sql .= "'".$tag."'";
				$sql .= ")";
				$db->exec($sql);
			}
		}
		$msg = "タグの更新終了";
		redirectJS($msg);

	}elseif(!empty($_POST["csvexport"])){
		echo("<br>");
		echo("汎用CSV形式でのエクスポート");
//		$filepath = realpath($basedir."/export/csvexport.csv");
		$filepath = $basedir."/export/csvexport.csv";
		$tablename = "calendar_export";

		//カラム名の取得
		$sql  = "PRAGMA table_info(".$tablename.")";
		$pragma_result = $db->query($sql);
		$i=0;
		while( $cols = $pragma_result->fetch() )  {
			$calendar_export_cols[$i] = $cols["name"];
			$i++;
		}
		$max_cols = $i;

		//ビューからデータの取得
		$sql  = "SELECT * from ".$tablename;

		$result = $db->query($sql);
		$cols_counter = 0;
		while( $data = $result->fetch() )  {

			for($cols_counter=0;$cols_counter<$max_cols;$cols_counter++){
				$calendar_export_data[$i][$calendar_export_cols[$cols_counter]] = ''.$data[$calendar_export_cols[$cols_counter]].'';
			}
			$calendar_export_data[$i]["detail"] = str_replace("\n",PHP_EOL,$calendar_export_data[$i]["detail"]);
			$calendar_export_data[$i]["detail"] = '"'.$calendar_export_data[$i]["detail"].'"';
			
			if($calendar_export_data[$i]["vaguedate_f"] == 0){
				$temp_starttime = sprintf("%04d", $calendar_export_data[$i]["starttime"]);
				$temp_starttime2 = substr($temp_starttime,0,2).":".substr($temp_starttime,2,2);
				$calendar_export_data[$i]["starttime"] = $temp_starttime2;
				$calendar_export_data[$i]["starttime2"] = $temp_starttime2;
				if(!empty($calendar_export_data[$i]["endtime"])){
					$temp_endtime = sprintf("%04d", $calendar_export_data[$i]["endtime"]);
					$temp_endtime2 = substr($temp_endtime,0,2).":".substr($temp_endtime,2,2);
					$calendar_export_data[$i]["endtime"] = $temp_endtime2;
				}
			}

			$csvdata[$i+1] = implode(",",$calendar_export_data[$i]);
			$i++;
		}
		$max_lines = $i;
		$csvdata[0] = implode(",",$calendar_export_cols);
		
		$handle = fopen($filepath, 'w');
		if($handle){
			echo(2);
			fwrite($handle, $csvdata[0]);
			fwrite($handle,"\n");
			for($i=1;$i<=$max_lines;$i++){
				if($csvdata[$i] != ""){
					fwrite($handle, $csvdata[$i]);
					fwrite($handle,"\n");
				}
			}
			fclose($handle);
		}
//		if(FILE_LOCK)unlock("index.rdf");

		echo("CSVデータのエクスポート終了。データは/data/export/csvexport.csvに保存されています。");
		$msg = "CSVデータのエクスポート終了。データは".$webdataroot."export/csvexport.csvに保存されています。";
		redirectJS($msg);
	
		


	}elseif(!empty($_POST["icalexport"])){

		exportiCalendar($db, $basedir, $confData);

	}elseif(!empty($_POST["deleteall"])){
			$sql  = "DELETE FROM calendar ";
			$db->exec($sql);
			$sql  = "DELETE FROM calendar_member ";
			$db->exec($sql);
			$sql  = "DELETE FROM category ";
			$db->exec($sql);
			$sql  = "DELETE FROM member ";
			$db->exec($sql);
			$sql  = "DELETE FROM tag ";
			$db->exec($sql);

			echo("カレンダーデータを削除しました。");
			$msg = "カレンダーデータを削除しました。";
			redirectJS($msg);
	
	}else{
		echo("");
	}
}
?>

<div id="pageimage">
<h1 class='headerh1'><a href='../index.php'><?php echo($calname); ?></a></h1>
<h2><span class='marker'>&#x2756;</span>&nbsp;データインポートとエクスポート</h2>
<style>
.menu_jump li{
	display: inline-block; 
	font-size: 70%;
	padding-left: 0.5em;
}
.menu_jump li a:before {
	content: "[";
	padding-left: 0.5em;
}

.menu_jump li a:after {
	content:"]";
}
</style>
<div style="text-align: center;">
	<ul class="menu_jump" style="list-style-type: none; margin: 0 auto 0 auto; width: 800px; text-align: left;">
		<li><a href="#csvexport">CSV形式でのエクスポート</a></li>
		<li><a href="#icalexport">iCalendar形式でのエクスポート</a></li>
		<li><a href="#csvimport">簡易CSV形式でのインポート</a></li>
		<li><a href="#duplicatedb">dbファイルを別名で待避</a></li>
		<li><a href="#importfrom03">ver0.3系統からのインポート</a></li>
		<li><a href="#importfrom20">ver2.0系統からのインポート</a></li>
		<li><a href="#importcustom">カスタム形式でのインポート</a></li>
		<li><a href="#importholiday">休日・祝日データのインポート</a></li>
		<li><a href="#importstaticholiday">固定休日データのインポート</a></li>
		<li><a href="#import_memcolor">メンバーの色設定データのインポート</a></li>
		<li><a href="#importcategorycolor">カテゴリの色設定データのインポート</a></li>
		<li><a href="#edittags">タグの編集</a></li>

		
	</ul>
</div>

<form action="admin_data.php" method="post">
<div id="adminmenu">
	<a name="csvexport">&nbsp;</a>
	<div class="import_area">
		<h2>CSV形式でのエクスポート</h2>
		<div class="paragraph">
			汎用CSV形式でエクスポートします。<br>
			<input type="submit" name="csvexport" value="CSVエクスポート" class="ui-button ui-corner-all button">
			<ul>
				<li>他のシステムにデータをエクスポートしたい場合に使用してください。</li>
				<li><a href="<?php echo($webdataroot); ?>export/csvexport.csv">データダウンロード</a></li>
			</ul>

		</div>
	</div>

	<a name="icalexport">&nbsp;</a>
	<div class="import_area">
		<h2>iCalendar形式でのエクスポート</h2>
		<div class="paragraph">
			iCalendar形式でエクスポートします。<br>
			<input type="submit" name="icalexport" value="iCalendarエクスポート" class="ui-button ui-corner-all button">
			<ul>
				<li>他のシステムにデータをエクスポートしたい場合に使用してください。</li>
				<li><a href="<?php echo($webdataroot); ?>export/export.ics">データダウンロード</a></li>
			</ul>

		</div>
	</div>

	<a name="csvimport">&nbsp;</a>
	<div class="import_area">
		<h2>簡易CSV形式でのインポート</h2>
		<div class="paragraph">
			CSV形式でインポートします。<br>
			<ul>
				<li>
					<?php echo($uname);?>3をインストールしたサーバーの<div class="path">/data/import/csv/</div>フォルダ内に、<span class='filename'>import.csv</span>をコピーしてください。<br>
				</li>
			</ul>
			入力データ形式は，以下の通りです。
			<div class="code">日付,開始時刻,終了時刻,イベントタイトル,イベント詳細,場所,メンバーID,カテゴリID</div>
			<br>
			<table class="import">
				<tr>
					<th>内容</th><th>形式</th><th>注意点</th>
				</tr>
				<tr>
					<td>日付</td><td>YYYY-MM-DD</td><td>必須</td>
				</tr>
				<tr>
					<td>開始時刻</td><td>HH:MM<br>時刻の代わりに以下の記載が使用できます。<br>午前の場合：AM<br>午後の場合：PM<br>未定の場合：ALL1<br>終日の場合：ALL2</td><td>必須</td>
				</tr>
				<tr>
					<td>終了時刻</td><td>HH:MMまたはNULL<br>開始時刻が時刻以外の場合は無視されます。</td><td></td>
				</tr>
				<tr>
					<td>イベントタイトル</td><td></td><td>必須<br>,（カンマ）や'（シングルクオーテーション）や"（ダブルクオーテーション）を含めないでください。</td>
				</tr>
				<tr>
					<td>イベント詳細</td><td></td><td>,（カンマ）や'（シングルクオーテーション）や"（ダブルクオーテーション）を含めないでください。</td>
				</tr>
				<tr>
					<td>場所</td><td></td><td>,（カンマ）や'（シングルクオーテーション）や"（ダブルクオーテーション）を含めないでください。</td>
				</tr>
				<tr>
					<td>メンバーID</td><td>メンバーIDをスペース区切りで列挙</td><td>メンバーIDは、メンバー設定画面に表示されているIDと対応します。</td>
				</tr>
				<tr>
					<td>カテゴリID</td><td>カテゴリIDを1つだけ記載</td><td>カテゴリIDは、カテゴリ設定画面に表示されているIDと対応します。</td>
				</tr>
			</table>
			例
			<div class="code">
				2017-11-17,08:30,,会議,打ち合わせ,会議室,1 4 3,1<br>
				2017-12-01,ALL1,,仙台出張,,,4,<br>
				2017-12-03,10:00,17:00,展示会実施,,イベントホール,,<br>
				2017-12-02,08:30,9:30,商品企画会議,新製品開発に向けてブレインストーミング,会議室,2 3 4,2
			</div>
			<input type="submit" name="csvimport" value="CSVインポート" class="ui-button ui-corner-all button">
			<br>
			<br>
			こちらのフォームに上記CSV形式を入力することでもインポートできます。
			<textarea name="uni/importdata" cols="80" rows="10"></textarea>
			<br>
			<input type="submit" name="csvimportform" value="フォームからCSVインポート" class="ui-button ui-corner-all button">

		</div>
	</div>
	<a name="duplicatedb">&nbsp;</a>
	<div class="import_area">
		<h2>dbファイルを別名で待避</h2>
		<div class="paragraph">
			dbファイルを別名で同じフォルダにコピーします。復元はサーバ上のdataフォルダ内を操作してください。<br>
			<input type="submit" name="dbcopy" value="dbファイルコピー待避" class="ui-button ui-corner-all button">
			<ul>
				<li>インポート前のバックアップ等に使うと良いでしょう。</li>
			</ul>

		</div>
	</div>

	<a name="importfrom03">&nbsp;</a>
	<div class="import_area">
		<h2><?php echo($uname); ?> ver0.3系統からのインポート</h2>
		<div class="paragraph">
			すでに稼動していて、データを入力した<?php echo($uname); ?>3環境にもインポートできますが、不整合が発生する可能性があります。<br>
			<br>
			手順：<br>
			<ol>
			<li>
				<?php echo($uname); ?> ver0.3系統の稼働画面の右下にある「CSV rebuild」をクリックして、最新のCSVを作成してください。<br>
			</li>
			<li>
				作成した<span class='filename'>export.csv</span>ファイルをダウンロードしてください。<br>
			</li>
			<li><?php echo($uname);?>3をインストールしたサーバーの<div class="path">/data/import/03/</div>フォルダ内に、<?php echo($uname);?>ver0.3系統のインストールフォルダにある、<span class='filename'>config.php</span>と、先ほど作成した<span class='filename'>export.csv</span>をコピーしてください。<br>
			<span class='filename'>config.php</span>は，<?php echo($uname);?>ver0.3インストールフォルダ内の、confフォルダの中にあります。<br>
			</li>
<?php
/*
			<li>
			ver0.3系統が稼働しているURLを指定してください。(index.phpは不要です。)
			<input type="text" name="u03url" size="60" value="http://www.unicale.com/unicaledemo/">
			</li>
*/
?>			<li>
			下の「<?php echo($uname); ?> ver0.3系統からインポート」ボタンを押すと開始します。<br>途中で止まった場合は、データの不整合が発生しますので、インストールフォルダを削除してから最初からやり直してください。<br>
			（新規）は既存のデータを消去してインポートします。（追加）は既存のデータにできる限り追加します。<br>
			<input type="submit" name="u03importnew" value="<?php echo($uname); ?> ver0.3系統からインポート（新規）" class="ui-button ui-corner-all button">
			<input type="submit" name="u03import" value="<?php echo($uname); ?> ver0.3系統からインポート（追加）" class="ui-button ui-corner-all button">
			</li>
			</ol>
			<ul>
				<li>カテゴリー（ジャンル）データは反映されません。</li>
				<li>メンバーの2文字の名前を元に、関連付けをしています。同じ2文字名称のメンバーが存在していた場合、メンバーとイベントデータの関連付けで不整合が発生する可能性があります。</li>
				<li>2回インポートを行うと、同じデータがどんどん追加されてしまいますので、失敗したら、インストールからやり直してください。</li>
				<li>イベントの日付が古いデータをインポートすると、表示設定の表示開始年より古い場合、下部ナビゲーションに表示されないので、「設定」から表示開始年を古い年に合わせてください。</li>
			</ul>
		</div>
	</div>
	<a name="importfrom20">&nbsp;</a>
	<div class="import_area">
		<h2><?php echo($uname); ?> ver2.0系統からのインポート</h2>
		<div class="paragraph">
			手順：<br>
			<ol>
			<li>1.<?php echo($uname);?>3をインストールしたサーバーの<div class="path">/data/import/20/</div>フォルダ内に、<?php echo($uname);?>ver2.0系統のインストールフォルダにある、以下の3つのファイルをコピーしてください。<br>
			・<span class='filename'>d_data.txt</span><br>
			・<span class='filename'>d_member.txt</span><br>
			・<span class='filename'>d_genre.txt</span><br>
			3つのファイルは、config.phpは，<?php echo($uname);?>ver2.0系統のインストールフォルダ内の、dataフォルダの中にあります。<br>
			</li>
			<li>
			下の「<?php echo($uname); ?> ver2.0系統からインポート」ボタンを押すと開始します。<br>途中で止まった場合は、データの不整合が発生しますので、インストールフォルダを削除してから最初からやり直してください。<br>
			<input type="submit" name="u20import" value="<?php echo($uname); ?> ver2.0系統からのインポート" class="ui-button ui-corner-all button">
			</li>
			</ol>
			<ul>
				<li>カテゴリーの色データは、色が自動的に割り振られます。</li>
				<li>メンバーの色データは、色が自動的に割り振られます。</li>
				<li>データ内のイベントのタイトル等に「,」（半角カンマ）が含まれていると，動作しない場合があります。</li>
				<li>2回インポートを行うと、同じデータがどんどん追加されてしまいますので、失敗したら、インストールからやり直してください。</li>
				<li>イベントの日付が古いデータをインポートすると、表示設定の表示開始年より古い場合、下部ナビゲーションに表示されないので、「設定」から表示開始年を古い年に合わせてください。</li>
			</ul>
		</div>
	</div>

<!--
		<a name="importfromGoogleC">&nbsp;</a>
		<div class="import_area">
		<h2>Googleカレンダーからのインポート</h2>
		<div class="paragraph">
			未実装<br>
			<input type="submit" name="gc_import" value="Googleカレンダーからのインポート" class="ui-button ui-corner-all button">
		</div>
	</div>
-->
	<a name="importcustom">&nbsp;</a>
	<div class="import_area">
		<h2>カスタム形式でのインポート</h2>
		<div class="paragraph">
			未実装<br>
			<input type="submit" name="custom_import" value="カスタム形式でのインポート" class="ui-button ui-corner-all button">
		</div>
	</div>

	<a name="importeventstatic">&nbsp;</a>
	<div class="import_area">
		<h2>固定年次イベントデータのインポート</h2>
		<div class="paragraph">
			毎年発生する年次日付固定のデータをインポートします。（誕生日，創立記念日，等）<br>
			<?php echo($uname);?>3をインストールしたサーバーの<div class="path">/data/import/</div>フォルダ内に、<span class='filename'>event_static.csv</span>を置いてください。<br>
			既存のイベント固定データに上書きされます。<br>
			<input type="submit" name="event_static_import" value="固定イベントインポート" class="ui-button ui-corner-all button">
		</div>
	</div>

	<a name="importholiday">&nbsp;</a>
	<div class="import_area">
		<h2>休日・祝日データのインポート</h2>
		<div class="paragraph">
			初期データは、インストール時に自動的に読み込まれています。通常使用において、この機能を使う必要はありません。<br>
			<?php echo($uname);?>3をインストールしたサーバーの<div class="path">/data/import/</div>フォルダ内に、<span class='filename'>holiday.csv</span>を置いてください。<br>
			既存の休日・祝日データに上書きされます。<br>
			<input type="submit" name="holiday_import" value="祝日インポート" class="ui-button ui-corner-all button">
		</div>
	</div>

	<a name="importstaticholiday">&nbsp;</a>
	<div class="import_area">
		<h2>固定休日データのインポート</h2>
		<div class="paragraph">
			初期データは、インストール時に自動的に読み込まれています。通常使用において、この機能を使う必要はありません。<br>
			<?php echo($uname);?>3をインストールしたサーバーの<div class="path">/data/import/</div>フォルダ内に、<span class='filename'>holiday_static.csv</span>を置いてください。<br>
			既存の固定休日データに上書きされます。<br>
			<input type="submit" name="holiday_static_import" value="固定休日インポート" class="ui-button ui-corner-all button">
		</div>
	</div>

	<a name="import_memcolor">&nbsp;</a>
	<div class="import_area">
		<h2>メンバーの色設定データのインポート</h2>
		<div class="paragraph">
			初期データは、インストール時に自動的に読み込まれています。通常使用において、この機能を使う必要はありません。<br>
			<?php echo($uname);?>3をインストールしたサーバーの<div class="path">/data/import/</div>フォルダ内に、<span class='filename'>member_color.csv</span>を置いてください。<br>
			既存のメンバー色データに上書きされます。<br>
			<input type="submit" name="memcolor_import" value="メンバー色データインポート" class="ui-button ui-corner-all button">
		</div>
	</div>

	<a name="importcategorycolor">&nbsp;</a>
	<div class="import_area">
		<h2>カテゴリの色設定データのインポート</h2>
		<div class="paragraph">
			初期データは、インストール時に自動的に読み込まれています。通常使用において、この機能を使う必要はありません。<br>
			<?php echo($uname);?>3をインストールしたサーバーの<div class="path">/data/import/</div>フォルダ内に、<span class='filename'>category_color.csv</span>を置いてください。<br>
			既存のカテゴリ色データに上書きされます。<br>
			<input type="submit" name="categorycolor_import" value="カテゴリー色データインポート" class="ui-button ui-corner-all button">
		</div>
	</div>

	<a name="edittags">&nbsp;</a>
	<div class="import_area">
		<h2>タグの編集</h2>
		<div class="paragraph">
			一行にひとつのタグを記載して下さい。既存のタグを削除することもできます。重複が発生した場合はそのまま「タグ更新」を押して下さい。<br>
			<textarea name="uni/tags" cols="80" rows="10"><?php echo(htmlspecialchars(initTags($db))); ?></textarea>
			<br>
			<input type="submit" name="edittags" value="タグ更新" class="ui-button ui-corner-all button">
		</div>
	</div>

<?php
/*
	<div class="import_area">
		<h2>データーの全削除</h2>
		<div class="paragraph">
			カレンダー、メンバー、カテゴリの情報をすべて削除します。<br>
			不安な場合は、バックアップを取ってから実行してください。
			<input type="submit" name="deleteall" value="全データ削除" class="ui-button ui-corner-all button">
		</div>
	</div>
*/
?>
</div>
</form>
<a href="../index.php">トップページへ戻る</a>
<?php
$unicom->dispCopyright($confData);
$unicom->dispRss();
?>
</div>
<script>
//	$(document).ready( function() {
//	$('#adminmenu').accordion({header: "h2"});
//});	
</script>
</body>
</html>

<?php
function getChar2CodeList(){
	//未使用
	$char2code = array();
	$char2code["_SEMICORON_"] = ";";
	$char2code["_CORON_"] = ":";
	$char2code["_LINE_FEED_"] = "\\n";
	$char2code["_SLASH_"] = "/";
	$char2code["_TAB_"] = "\\t";
	$char2code["_COMMA_"] = ",";
	$char2code["_DOT_"] = ".";
	$char2code["_ESCAPE_"] = "\\";
	return $char2code;
	
}
function replaceChar2Code($inchar){
	$search_char = array("_SEMICORON_", "_CORON_", "_LINE_FEED_","_SLASH_","_TAB_","_COMMA_","_DOT_","_ESCAPE_");
	$target_char   = array(";", ":", "\\n", "/", "\\t",",",".","\\");
	$outchar = str_replace($search_char, $target_char, $inchar);
	return $outchar;
}
function cvtEUC2UTF8($inchar){
	$outchar = mb_convert_encoding(mb_convert_encoding($inchar, "sjis-win", "eucJP-win"), "UTF-8", "sjis-win");
	//$outchar = mb_convert_encoding($inchar, "UTF-8", "sjis-win");
	return $outchar;
}

function cvtSJIS2UTF8($inchar){
	//$outchar = mb_convert_encoding(mb_convert_encoding($inchar, "sjis-win", "eucJP-win"), "UTF-8", "sjis-win");
	$outchar = mb_convert_encoding($inchar, "UTF-8", "sjis-win");
	return $outchar;
}

 /*
 * テキストファイルの文字コードを変換し保存する
 * @param string $infname  入力ファイル名
 * @param string $incode   入力ファイルの文字コード
 * @param string $outfname 出力ファイル名
 * @param string $outcode  出力ファイルの文字コード
 * @param string $nl	   出力ファイルの改行コード
 * @return string メッセージ
*/

function convertCode($infname, $incode, $outfname, $outcode, $nl) {
	$instr = @file_get_contents($infname);
	if ($instr == FALSE) {
		return "変換失敗：{$infname} が見あたりません．";
	}
	$outstr = mb_convert_encoding($instr, $outcode, $incode);
	$outstr = str_replace(array("\r\n", "\n", "\r"), $nl, $outstr);

	$outfp = fopen($outfname, 'wb');
	if ($outfp == FALSE) {
		return "変換失敗：{$outfname} に書き込むことができません．";
	}
	fwrite($outfp, $outstr);
	fclose($outfp);

	return "変換成功：{$infname} => {$outfname}";
}

function initTags($db){
	$tagnames = "";
	$sql  = "SELECT tagname FROM tag; ";
	$result = $db->query($sql);
	while( $tagname = $result->fetch() )  {
		$tagnames .= $tagname["tagname"] ."\n";
	}
	return($tagnames);
}

/*
function updateTags($db)
$sql  = "DELETE FROM calendar ";
$db->exec($sql);
*/


function redirectJS($msg){
	echo("<script language='Javascript'>");
	echo("alert('".$msg."');");
//	echo("location.href = 'admin_data.php';");
	echo("</script>");
}

function exportiCalendar($db, $basedir, $confData){
	echo("<br>");
	echo("iCalendar形式でのエクスポート");
	$filepath = $basedir."/export/export.ics";
	$tablename = "calendar_export";

	//カラム名の取得
	$sql  = "PRAGMA table_info(".$tablename.")";
	$pragma_result = $db->query($sql);
	$i=0;
	while( $cols = $pragma_result->fetch() )  {
		$calendar_export_cols[$i] = $cols["name"];
		$i++;
	}
	$max_cols = $i;

	//ビューからデータの取得
	$sql  = "SELECT ";
	$sql .= "id, ";
	$sql .= "startdate, ";
	$sql .= "datemode, ";
	$sql .= "vaguedate_f, ";
	$sql .= "enddate, ";
	$sql .= "starttime, ";
	$sql .= "endtime, ";
	$sql .= "starttime_zone, ";
	$sql .= "starttime_real, ";
	$sql .= "title, ";
	$sql .= "detail, ";
	$sql .= "member, ";
	$sql .= "place, ";
	$sql .= "category, ";
	$sql .= "silent, ";
	$sql .= "level, ";
	$sql .= "usehour, ";
	$sql .= "modified, ";
	$sql .= "pickup, ";
	$sql .= "f_insert, ";
	$sql .= "opt1, ";
	$sql .= "opt2, ";
	$sql .= "opt3, ";
	$sql .= "members, ";
	$sql .= "starttime2, ";
	$sql .= "categoryname ";
	$sql .= "FROM ";
	$sql .= " ".$tablename." ";
	$result = $db->query($sql);

	$cols_counter = 0;
	$i = 0;
	while( $data = $result->fetch() )  {
		for($cols_counter=0;$cols_counter<$max_cols;$cols_counter++){
			$calendar_export_data[$i][$calendar_export_cols[$cols_counter]] = ''.$data[$calendar_export_cols[$cols_counter]].'';
		}

		$calendar_export_data[$i]["detail"] = str_replace("\n",PHP_EOL,$calendar_export_data[$i]["detail"]);
		$calendar_export_data[$i]["detail"] = '"'.$calendar_export_data[$i]["detail"].'"';

		if($calendar_export_data[$i]["vaguedate_f"] == 0){
			$temp_starttime = sprintf("%04d", $calendar_export_data[$i]["starttime"]);
			$temp_starttime2 = substr($temp_starttime,0,2).":".substr($temp_starttime,2,2);
			$calendar_export_data[$i]["starttime"] = $temp_starttime2;
			$calendar_export_data[$i]["starttime2"] = $temp_starttime2;
			if(!empty($calendar_export_data[$i]["endtime"])){
				$temp_endtime = sprintf("%04d", $calendar_export_data[$i]["endtime"]);
				$temp_endtime2 = substr($temp_endtime,0,2).":".substr($temp_endtime,2,2);
				$calendar_export_data[$i]["endtime"] = $temp_endtime2;
			}
		}
		$i++;
	}
	$max_lines = $i;

	$handle = fopen($filepath, 'w');
	if($handle){
		fwrite($handle, iCalendarHeader());
		for($i=0;$i<$max_lines;$i++){
			fwrite($handle, makeiCalendarData($confData, $calendar_export_data[$i]));
		}
		fwrite($handle, iCalendarFooter());
		fclose($handle);
	}

	echo("iCalendarデータのエクスポート終了。データは/data/export/export.icsに保存されています。");
	$msg = "iCalendarデータのエクスポート終了。データは".$webdataroot."export/export.icsに保存されています。";
	redirectJS($msg);
}

function iCalendarHeader($confData){
	$outputStringHeader  = "BEGIN:VCALENDAR\n";
	$outputStringHeader .= "PRODID:-//UNICALE//".UVERSION."//JP\n";
	$outputStringHeader .= "VERSION:2.0\n";
	$outputStringHeader .= "CALSCALE:GREGORIAN\n";
	$outputStringHeader .= "METHOD:PUBLISH\n";
	$outputStringHeader .= "X-WR-CALNAME:".$confData->conf["calname"]."\n";
	$outputStringHeader .= "X-WR-TIMEZONE:".date_default_timezone_get()."\n"; //ex. Asia/Tokyo
	$outputStringHeader .= "X-WR-CALDESC:\n";
	return($outputStringHeader);
}

function iCalendarFooter(){
	$outputStringFooter  = "END:VCALENDAR\n";
	return($outputStringFooter);
}

function makeiCalendarData($confData, $calendar_export_data){
	$outputiCalendarString = "BEGIN:VEVENT\n";

	if(($calendar_export_data["vaguedate_f"]) == 1){
		if(($calendar_export_data["starttime"]=="ALL1")||($calendar_export_data["starttime"]=="ALL2")){
			$startdatetime = strtotime($calendar_export_data["startdate"]);
			$startdatetime = date('Ymd',$startdatetime);
			$enddatetime = strtotime($calendar_export_data["startdate"]);
			$enddatetime = date('Ymd',$enddatetime);
		}else{
			$startdatetime = strtotime($calendar_export_data["startdate"]." ".$calendar_export_data["starttime_real"]);
			$startdatetime = date('Ymd\THis',$startdatetime);
			$enddatetime = strtotime($calendar_export_data["startdate"]." ".$calendar_export_data["starttime_real"]);
			$enddatetime = date('Ymd\THis',$enddatetime);
		}
	}else{
		$startdatetime = strtotime($calendar_export_data["startdate"]." ".$calendar_export_data["starttime_real"]);
		$startdatetime = date('Ymd\THis',$startdatetime);
		$enddatetime = strtotime($calendar_export_data["startdate"]." ".$calendar_export_data["endtime"]);
		$enddatetime = date('Ymd\THis',$enddatetime);
	}

	if($calendar_export_data["place"] != ""){
		$icalendar_place = "".$calendar_export_data["place"]."";
	}else{
		$icalendar_place = "";
	}

	if(($calendar_export_data["modified"]) != ""){
		$icalendar_modified = strtotime($calendar_export_data["modified"]);
		$icalendar_modified = date('Ymd\THis',$icalendar_modified);
	}else{
		$icalendar_modified = date('Ymd');
	}

	$icalendar_detail = trim($calendar_export_data["detail"],"\"");
	$icalendar_detail = str_replace("\n","\\n",$icalendar_detail);
	$icalendar_detail = str_replace("\r","\\n",$icalendar_detail);
	if(($calendar_export_data["vaguedate_f"]) == 1){
		$icalendar_detail = $calendar_export_data["starttime"]." ".$icalendar_detail;
	}

	$outputiCalendarString .= "UID:".$confData->conf["calname"]."-".$startdatetime."-".$calendar_export_data["id"]."\n";
	$outputiCalendarString .= "DTSTART:".$startdatetime."\n";
	$outputiCalendarString .= "DTEND:".$enddatetime."\n";
	$outputiCalendarString .= "DTSTAMP:".$icalendar_modified."\n";
	$outputiCalendarString .= "DESCRIPTION:".$icalendar_detail;
	if($icalendar_place != ""){
		$outputiCalendarString .= " \\n";
		$outputiCalendarString .= "Place: ".$icalendar_place;
	}
	if($calendar_export_data["members"] != ""){
		$outputiCalendarString .= " \\n";
		$outputiCalendarString .= "Member: ".$calendar_export_data["members"];
	}
	$outputiCalendarString .= "\n";
	$outputiCalendarString .= "CATEGORIES:".$calendar_export_data["categoryname"]."\n";
	$outputiCalendarString .= "LOCATION:".$calendar_export_data["place"]."\n";
	$outputiCalendarString .= "SEQUENCE:0\n";
	$outputiCalendarString .= "STATUS:CONFIRMED\n";
	$outputiCalendarString .= "SUMMARY:".$calendar_export_data["title"]."\n";
	$outputiCalendarString .= "TRANSP:OPAQUE\n";
	$outputiCalendarString .= "END:VEVENT\n";

	return ($outputiCalendarString);
}

?>


