<?php


require_once('../lib/unicom.php');
ini_set('display_errors', DISP_ERR);

if (! $db = new PDO("sqlite:../data/unicale.db")) {
	die("DB Connection Failed.");
}
$db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
$unicom = new unicom();
$checkSubmit = new checkSubmit();
$confData = new confData();

$confData->getConfData($db);
$calname = $confData->conf["calname"];

$error_f = 0;

?>

<html>
	<head>
		<link rel="stylesheet" type="text/css" href="../css/ucal_common.css"  media="all">
		<link rel="stylesheet" type="text/css" href="../css/ucalp.css" media="print">
		<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
		<link type="text/css" href="../js/jquery-ui-1.12.1.custom/jquery-ui.theme.min.css" rel="Stylesheet" />
		<script type="text/javascript" src="../js/jquery-3.2.1.min.js"></script>
		<script type="text/javascript" src="../js/jquery-ui-1.12.1.custom/jquery-ui.js"></script>
		<title><?php echo $calname; ?>設定</title>
	</head>
	<body>
	<div id="pageimage">
<?php
		
$conf_colnames = array(
	'カレンダー名称',			//1
	'掲示板機能有効',			//2
	'表示開始年',			//3
	'表示終了年',			//4
	'カテゴリ表示方法',			//5
	'週の始まり曜日',			//6
	'月替わりナビゲーション始まり月', //7
	'PICKUP表示',				//8
	'イベントカレンダーモード',	   //9
	'',			//10
	'',			//11
	'',			//12
	'外部UNICALEのURL'			//13

);
$conf_colnames_second = array(
	'',						//1
	'',						//2
	'省略時は現在年',			//3
	'省略時は現在年より5年後',		//4
	'(未実装)',				//5
	'',						//6
	'',						//7
	'',						//8
	'',				//9
	'(将来拡張用)',			//10
	'(将来拡張用)',			//11
	'(将来拡張用)',			//12
	'このURLはサーバには保存されません。各ブラウザのCookieに保存されます。'			//13
);
$conf_colnames_required = array(
	0,	//1
	0,	//2
	0,	//3
	0,	//4
	0,	//5
	0,	//6
	0,	//7
	0,	//8
	0,	//9
	0,	//10
	0,	//11
	0,	//12
	0	//13
);

if ($_SERVER["REQUEST_METHOD"] === "POST") {
	$update_calname = "";
	$update_f_keiji_mode = 0;
	$update_startyear = 0;
	$update_endyear = 0;
	$update_disp_category_flat = 0;
	$update_monorsun = 0;
	$update_monthnavistartmonth = 4;
	$update_f_pickup_disp = 0;
	$update_event_calendar_mode = 0;
	$update_opt1 = "";
	$update_opt2 = "";
	$update_opt3 = "";

	$error_f = 0;
	$error_msg = "";

	for($i=1; $i<=12; $i++){
		switch($i){
			case 1:
				$temp_arg = "uni/calname";
				if(!empty($_POST[$temp_arg])){
					$update_calname = $checkSubmit->sanitize($_POST[$temp_arg]);
				}
				break;
			case 2:
				$temp_arg = "uni/f_keiji_mode";
				if(!empty($_POST[$temp_arg])){
					$update_f_keiji_mode = (int) $_POST[$temp_arg];
				}
				break;
			case 3:
				$temp_arg = "uni/startyear";
				if(!empty($_POST[$temp_arg])){
					$update_startyear = (int) $_POST[$temp_arg];
				}
				break;
			case 4:
				$temp_arg = "uni/endyear";
				if(!empty($_POST[$temp_arg])){
					$update_endyear = (int) $_POST[$temp_arg];
				}else{
					$update_endyear = $update_startyear + 5;
				}
				break;
			case 5:
				$temp_arg = "uni/disp_category_flat";
				if(!empty($_POST[$temp_arg])){
					$update_disp_category_flat = (int) $_POST[$temp_arg];
				}
				break;
			case 6:
				$temp_arg = "uni/monorsun";
				if(!empty($_POST[$temp_arg])){
					$update_monorsun = $checkSubmit->sanitize($_POST[$temp_arg]);
				}
				break;
			case 7:
				$temp_arg = "uni/monthnavistartmonth";
				if(!empty($_POST[$temp_arg])){
					$update_monthnavistartmonth = (int) $_POST[$temp_arg];
				}
				break;
			case 8:
				$temp_arg = "uni/event_calendar_mode";
				if(!empty($_POST[$temp_arg])){
					$update_event_calendar_mode = (int) $_POST[$temp_arg];
				}
				break;
			case 9:
				$temp_arg = "uni/f_pickup_disp";
				if(!empty($_POST[$temp_arg])){
					$update_f_pickup_disp = (int) $_POST[$temp_arg];
				}
				break;
			case 10:
				$temp_arg = "uni/opt1";
				if(!empty($_POST[$temp_arg])){
					$update_opt1 = $checkSubmit->sanitize($_POST[$temp_arg]);
				}
				break;
			case 11:
				$temp_arg = "uni/opt2";
				if(!empty($_POST[$temp_arg])){
					$update_opt2 = $checkSubmit->sanitize($_POST[$temp_arg]);
				}
				break;
			case 12:
				$temp_arg = "uni/opt3";
				if(!empty($_POST[$temp_arg])){
					$update_opt3 = $checkSubmit->sanitize($_POST[$temp_arg]);
				}
				break;
		}
	}
	$update_f = 0;
	if($error_f ==0){
		$update_f = 1;  //更新か挿入を実施する
	}
	echo("<br>");

	if($update_f == 1){
		//UPDATE
		$sql  = "UPDATE conf SET ";
		$sql .= "calname = '".$update_calname."',";
		$sql .= "f_keiji_mode = ".$update_f_keiji_mode.",";
		$sql .= "startyear = ".$update_startyear.",";
		$sql .= "endyear = ".$update_endyear.",";
		$sql .= "disp_category_flat = ".$update_disp_category_flat.",";
		$sql .= "monorsun = ".$update_monorsun.",";
		$sql .= "monthnavistartmonth = ".$update_monthnavistartmonth.",";
		$sql .= "f_pickup_disp = ".$update_f_pickup_disp.",";
		$sql .= "event_calendar_mode = ".$update_event_calendar_mode.",";
		$sql .= "opt1 = '".$update_opt1."',";
		$sql .= "opt2 = '".$update_opt2."',";
		$sql .= "opt3 = '".$update_opt3."' ";

		$db->exec('begin');
		try {
			$db->exec($sql);
			$db->exec('commit');

		} catch (Exception $e) {
			$db->exec("ROLLBACK;");
			echo $e->getTraceAsString();
			return;
		}

		echo("更新しました。<br>");
		echo("<br>");
//		echo("<a href='.'>設定ページへ戻る</a><br>");
	}else{
//			echo("更新処理を行いません。");
	}
}

echo("<h1 class='headerh1'><a href='../index.php'>".$calname."</a></h1>");
echo("<h2><span class='marker'>&#x2756;</span>&nbsp;設定</h2>");
		
if($error_f != 0){
	echo("<div class='error_msg'>".$error_msg."<div>");
}

?>

<form action="admin_conf.php" method="post">
<?php

//設定データの取得
$sql  = "SELECT ";
$sql .= "calname, ";
$sql .= "f_keiji_mode,";
$sql .= "startyear, ";
$sql .= "endyear, ";
$sql .= "disp_category_flat, ";
$sql .= "monorsun, ";
$sql .= "monthnavistartmonth, ";
$sql .= "f_pickup_disp, ";
$sql .= "event_calendar_mode, ";
$sql .= "opt1, ";
$sql .= "opt2, ";
$sql .= "opt3 ";
$sql .= "FROM conf ";

$result = $db->query($sql);
while( $conf_data = $result->fetch() )  {
	$conf_init["calname"] = $conf_data["calname"];
	$conf_init["f_keiji_mode"] = $conf_data["f_keiji_mode"];
	$conf_init["startyear"] = $conf_data["startyear"];
	$conf_init["endyear"] = $conf_data["endyear"];
	$conf_init["disp_category_flat"] = $conf_data["disp_category_flat"];
	$conf_init["monorsun"] = $conf_data["monorsun"];
	$conf_init["monthnavistartmonth"] = $conf_data["monthnavistartmonth"];
	$conf_init["f_pickup_disp"] = $conf_data["f_pickup_disp"];
	$conf_init["event_calendar_mode"] = $conf_data["event_calendar_mode"];
	$conf_init["opt1"] = $conf_data["opt1"];
	$conf_init["opt2"] = $conf_data["opt2"];
	$conf_init["opt3"] = $conf_data["opt3"];
}

?>
<table class='admin1'>
<?php
	
//初期値設定
if(isset($conf_init)){
	$init_calname				= $conf_init["calname"];
	$init_f_keiji_mode			= $conf_init["f_keiji_mode"];
	$init_startyear				= $conf_init["startyear"];
	$init_endyear				= $conf_init["endyear"];
	$init_disp_category_flat	= $conf_init["disp_category_flat"];
	$init_monorsun				= $conf_init["monorsun"];
	$init_monthnavistartmonth	= $conf_init["monthnavistartmonth"];
	$init_f_pickup_disp			= $conf_init["f_pickup_disp"];
	$init_event_calendar_mode	= $conf_init["event_calendar_mode"];
	$init_opt1					= $conf_init["opt1"];
	$init_opt2					= $conf_init["opt2"];
	$init_opt3					= $conf_init["opt3"];
}else{
	$init_calname				= "";
	$init_f_keiji_mode			= "";
	$init_startyear				= "";
	$init_endyear				= "";
	$init_disp_category_flat	= 0;
	$init_monorsun				= 0;
	$init_monthnavistartmonth	= 4;
	$init_f_pickup_disp			= 1;
	$init_event_calendar_mode	= "";
	$init_opt1					= "";
	$init_opt2					= "";
	$init_opt3					= "";
}

for($i=1;$i<=13;$i++){
	echo("<tr>");
	echo("<td class='conf_table_header'>");
	echo($conf_colnames[$i-1]);
	echo("<br>");
	echo("<span class='member_colnames_second'>");
	echo($conf_colnames_second[$i-1]);
	echo("</span>");
	echo(disp_required($conf_colnames_required,$i-1));
	echo("</td>");
	echo("<td>");

	switch($i){
			case 1:
				echo("<input type='text' name='uni/calname' value='".$init_calname."' size='16'>");
				break;
			case 2:
				if($init_f_keiji_mode == 1){
					$checked_f_keiji_mode = " checked='CHECKED'";
				}else{
					$checked_f_keiji_mode = "";
				}
				echo("<input type='checkbox' name='uni/f_keiji_mode' value='1' ".$checked_f_keiji_mode.">");
				break;

			case 3:
				echo("<select name='uni/startyear'>");
				$currentYearYYYY = date('Y',time());
				echo("<option value='---'>---</option>");
				$f_selected = 0;
				for($j=1970;$j<2050;$j++){
					if($init_startyear != ""){
						if($j == $init_startyear){
							$startyear_selected = " SELECTED";
						}else{
							$startyear_selected = "";
						}
					}else{
						if($j == $currentYearYYYY){
							$startyear_selected = " SELECTED";
						}else{
							$startyear_selected = "";
						}
					}
					echo("<option value='".$j."' ".$startyear_selected.">".$j."</option>");
				}
				echo("</select>");
				break;
			case 4:
				echo("<select name='uni/endyear'>");
				$currentYearYYYY = date('Y',time());
				echo("<option value='---'>---</option>");
				for($j=1970;$j<2050;$j++){
					if($init_endyear != ""){
						if($j == $init_endyear){
							$endyear_selected = " SELECTED";
						}else{
							$endyear_selected = "";
						}
					}else{
						if($j == ($currentYearYYYY+5)){
							$endyear_selected = " SELECTED";
						}else{
							$endyear_selected = "";
						}
					}
					echo("<option value='".$j."' ".$endyear_selected.">".$j."</option>");
				}
				echo("</select>");
				break;
			case 5:
				echo("<select name='uni/disp_category_flat'>");
				$disp_category_flat_options[0] = "リスト表示";
				$disp_category_flat_options[1] = "フラット表示1";
				$disp_category_flat_options[2] = "フラット表示2";
				for($j=0; $j<3; $j++){

					if($j == $init_disp_category_flat){
						$disp_category_flat_selected = " SELECTED";
					}else{
						$disp_category_flat_selected = "";
					}
					echo("<option value='".$j."' ".$disp_category_flat_selected.">".$disp_category_flat_options[$j]."</option>");
				}
				echo("</select>");
				break;
			case 6:
				echo("<select name='uni/monorsun'>");
				$monorsun_options[0] = "日";
				$monorsun_options[1] = "月";
				//$monorsun_options[2] = "火";
				for($j=0; $j<=1; $j++){
					if($j == $init_monorsun){
						$monorsun_selected = " SELECTED";
					}else{
						$monorsun_selected = "";
					}
					echo("<option value='".$j."' ".$monorsun_selected.">".$monorsun_options[$j]."</option>");
				}
				echo("</select>");
				break;
			case 7:
				echo("<select name='uni/monthnavistartmonth'>");
				for($j=1; $j<=12; $j++){
					if($j == $init_monthnavistartmonth){
						$monthnavistartmonth_selected = " SELECTED";
					}else{
						$monthnavistartmonth_selected = "";
					}
					echo("<option value='".$j."' ".$monthnavistartmonth_selected.">".$j."月</option>");
				}
				echo("</select>");
				break;
			case 8:
				if($init_f_pickup_disp == 1){
					$checked_f_pickup_disp = " checked='CHECKED'";
				}else{
					$checked_f_pickup_disp = "";
				}
				echo("<input type='checkbox' name='uni/f_pickup_disp' value='1' ".$checked_f_pickup_disp.">");
				break;
			case 9:
				if($init_event_calendar_mode == 1){
					$checked_event_calendar_mode = " checked='CHECKED'";
				}else{
					$checked_event_calendar_mode = "";
				}
				echo("<input type='checkbox' name='uni/event_calendar_mode' value='1' ".$checked_event_calendar_mode.">");
				break;
			case 10:
				echo("<input type='text' name='uni/opt1' value='".$init_opt1."' size='8'>");
				break;
			case 11:
				echo("<input type='text' name='uni/opt2' value='".$init_opt2."' size='8'>");
				break;
			case 12:
				echo("<input type='text' name='uni/opt3' value='".$init_opt3."' size='8'>");
				break;
			case 13:
				echo("<input type='text' value='' name='extcalurl' id='extcalurl' size='20' onKeyup='change_extcalurl(this)'  onBlur='change_extcalurl(this)' >");
				break;
		echo("</td>");
		echo("</tr>");
	}
}
?>
</table>
<input type="submit" value="更新" class="ui-button ui-corner-all button">
<script>
function change_extcalurl(obj){
	var maxage=60*60*24*365*5;
	document.cookie = 'calurl='+encodeURIComponent(obj.value)+'; path=/; max-age='+maxage;
}


function getCookieArray(){
  var arr = new Array();
  if(document.cookie != ''){
    var tmp = document.cookie.split('; ');
    for(var i=0;i<tmp.length;i++){
      var data = tmp[i].split('=');
      arr[data[0]] = decodeURIComponent(data[1]);
    }
  }
  return arr;
}

$(function() {
	var arr = getCookieArray();
	var calurl = arr["calurl"];
  $('#extcalurl').val(calurl);
  
});
</script>

<?php
echo("</form>");
//$db->close();
$db = null;
echo("<a href='../index.php'>トップページへ戻る</a>");

echo("</div>");
echo("</body>");
echo("</html>");


function disp_required($conf_colnames_required,$checkcol){
	if($conf_colnames_required[$checkcol] == 1){
		$outputString = "<span class='col_required'>必須</span>";
	}else{
		$outputString = "";
	}
	return $outputString;
}

?>
